#!/bin/bash
# Initialize GEB Aesthetics project

set -euo pipefail

readonly PROJECT_NAME="${1:-}"
readonly PROJECT_TYPE="${2:-movie}"

if [[ -z "$PROJECT_NAME" ]]; then
    echo "Usage: init.sh <project_name> [movie|music|literature|game]"
    exit 1
fi

echo "🎨 GEB Aesthetics: Initializing project '$PROJECT_NAME'"
echo "   Type: $PROJECT_TYPE"

mkdir -p "$PROJECT_NAME"/{L1_Worldview,L2_Character,L3_Narrative,L4_Beat,L5_Execution,assets}

cat > "$PROJECT_NAME/README.md" << EOF
# $PROJECT_NAME

**Type**: $PROJECT_TYPE  
**Created**: $(date)

## Project Structure

- L1_Worldview/ - Universe constitution
- L2_Character/ - Agency and relationships
- L3_Narrative/ - Plot architecture
- L4_Beat/ - Scene sequencing
- L5_Execution/ - Final encoding
- assets/ - Multi-modal resources

## GEB Principles

1. **Recursion**: Each layer references and enriches others
2. **Emergence**: Beauty arises from constraint × freedom
3. **Unity**: Multi-modal synchronization

---
*Generated by GEB Aesthetics*
EOF

echo "✅ Project initialized: $PROJECT_NAME/"
