#!/bin/bash
# Setup script for Gateway Monitor Auto-Restart Skill

echo "Setting up Gateway Monitor Auto-Restart Skill..."

# Make the gateway monitor script executable
chmod +x gateway_monitor.sh

# Create logs directory if it doesn't exist
mkdir -p "$HOME/.openclaw/logs"

# Add cron job for 3-hour checks
(crontab -l 2>/dev/null | grep -v "gateway_monitor.sh"; echo "0 */3 * * * cd $(pwd) && ./gateway_monitor.sh >> $HOME/.openclaw/logs/cron_monitor.log 2>&1") | crontab -

echo "Gateway Monitor Auto-Restart Skill has been installed!"
echo "The monitoring script will run every 3 hours to check and restart the gateway if needed."
echo "Logs will be stored in $HOME/.openclaw/logs/"
echo ""
echo "To manually run the monitor: ./gateway_monitor.sh"
echo "To view logs: tail -f $HOME/.openclaw/logs/gateway_monitor.log"