# Gateway Monitor Auto-Restart Skill

Automatically monitors the OpenClaw gateway status and restarts it if it becomes unresponsive. Features 3-hour checks, smart restart logic, issue diagnosis, and 7-day log rotation.

## Description

This skill provides comprehensive monitoring for the OpenClaw gateway with automatic restart capabilities. It includes:

- Health checks every 3 hours
- Smart restart mechanism when gateway is down
- Issue diagnosis when startup fails
- 7-day log rotation system
- Fast recovery system that prioritizes quick gateway restart

## Features

- **Automatic Monitoring**: Checks gateway status every 3 hours
- **Smart Restart**: Restarts gateway when it becomes unresponsive
- **Issue Diagnosis**: Identifies and reports startup issues
- **Fast Recovery**: Prioritizes quick gateway restart
- **Log Management**: Maintains logs with 7-day rotation
- **Error Handling**: Gracefully handles "already running" errors

## Usage

The skill automatically sets up a cron job that runs the monitoring script every 3 hours. The monitoring system will:

1. Check if the gateway is responsive
2. If unresponsive, attempt to restart it
3. If restart fails, diagnose the issue
4. Log all activities with timestamp
5. Rotate logs older than 7 days

## Requirements

- OpenClaw gateway installed and configured
- Proper permissions to manage gateway service
- Cron access for scheduling checks

## Configuration

No additional configuration required. The skill automatically installs the monitoring system with optimal settings.