# Gateway Monitor Auto-Restart Skill

This skill provides automatic monitoring and restarting of the OpenClaw gateway to ensure maximum uptime.

## Overview

The Gateway Monitor Auto-Restart skill monitors your OpenClaw gateway and automatically restarts it if it becomes unresponsive. This ensures your OpenClaw system remains operational even if the gateway encounters issues.

## Features

- **Automatic Monitoring**: Checks gateway status every 3 hours
- **Smart Restart**: Restarts gateway when it becomes unresponsive
- **Issue Diagnosis**: Identifies and reports startup issues
- **Log Management**: Maintains logs with automatic rotation
- **Error Handling**: Gracefully handles various error conditions

## Installation

1. Navigate to the skill directory
2. Run the setup script: `./setup.sh`

## Usage

Once installed, the monitoring runs automatically every 3 hours. You can also run manual checks using:
```bash
./gateway_monitor.sh
```

## Configuration

The skill is designed to work out of the box with no configuration needed. However, you can modify the following in the script if needed:
- Check interval (currently every 3 hours)
- Log retention period (currently 7 days)

## Logs

- Main logs: `~/.openclaw/logs/gateway_monitor.log`
- Cron job logs: `~/.openclaw/logs/cron_monitor.log`

## Troubleshooting

If you encounter issues:
1. Check the logs in `~/.openclaw/logs/`
2. Ensure the gateway is properly installed: `openclaw gateway status`
3. Verify cron permissions: `crontab -l`