---
name: Gardening
description: Plant care, soil management, seasonal timing, pest control, and garden planning.
metadata:
  category: lifestyle
  skills: ["gardening", "plants", "vegetables", "landscaping", "horticulture"]
---

## Soil Fundamentals

- Test soil before amending — pH and nutrients determine what to add, not guessing
- Most plants prefer pH 6.0-7.0 — blueberries need acidic (4.5-5.5), lavender needs alkaline
- Compost fixes almost everything — improite clay drainage, sandy retention, feeds soil life
- Never work wet soil — compacts structure, takes years to recover
- Mulch 2-3 inches around plants — retains moisture, suppresses weeds, regulates temperature

## Watering Mistakes

- Deep infrequent > shallow frequent — trains roots to grow deep, builds resilience
- Morning watering best — leaves dry before night, reduces fungal disease
- Water soil, not leaves — wet foliage invites disease, wastes water
- Wilting in afternoon heat is normal — check morning, if still wilted then water
- Container plants dry faster — may need daily watering in summer

## Planting Timing

- Last frost date is starting point — count back for seed starting, forward for transplant
- Soil temperature matters more than air — cold soil rots seeds, use thermometer
- Cool season crops: lettuce, peas, broccoli — plant early spring and fall
- Warm season crops: tomatoes, peppers, squash — after soil reaches 60°F/15°C
- Perennials: plant in fall — roots establish over winter, less stress than spring

## Spacing Reality

- Seed packet spacing is minimum — crowded plants compete, underperform
- Air circulation prevents disease — don't pack plants together
- Mature size, not transplant size — that tiny tomato becomes 6 feet tall
- Vertical growing saves space — trellises for cucumbers, beans, tomatoes
- Succession planting: stagger sowings 2-3 weeks — continuous harvest, not glut

## Fertilizer Basics

- N-P-K: Nitrogen (leaves), Phosphorus (roots/flowers), Potassium (overall health)
- More is not better — overfertilizing burns roots, causes leggy growth
- Organic slow-release preferred — feeds soil life, not just plants
- Heavy feeders (tomatoes, corn) need more — light feeders (beans, herbs) need less
- Stop fertilizing 4-6 weeks before first frost — don't encourage tender growth

## Pest Management

- Identify before treating — wrong treatment wastes time, may harm beneficials
- Healthy plants resist pests better — soil health is pest prevention
- Beneficial insects: ladybugs eat aphids, wasps parasitize caterpillars — don't kill all bugs
- Physical barriers first: row covers, handpicking, water spray
- Pesticides last resort — even organic ones kill beneficials

## Common Pest Signs

| Sign | Likely Cause | First Response |
|------|--------------|----------------|
| Holes in leaves | Caterpillars, beetles | Handpick, Bt spray |
| Sticky residue | Aphids, scale | Strong water spray |
| White powder on leaves | Powdery mildew | Improve airflow, remove affected |
| Yellowing from bottom | Nitrogen deficiency or overwatering | Check soil moisture first |
| Wilting despite wet soil | Root rot | Reduce watering, improve drainage |

## Pruning Principles

- Clean cuts: sharp tools, just above node or bud — ragged cuts invite disease
- Prune spring bloomers after flowering — they set buds on old wood
- Prune summer bloomers in late winter — they bloom on new growth
- Remove dead/diseased/crossing branches first — the 3 Ds
- Never remove more than 1/3 at once — stresses plant, triggers excessive regrowth

## Composting

- Browns (carbon): dry leaves, cardboard, straw — provide structure
- Greens (nitrogen): kitchen scraps, grass clippings, coffee grounds — provide nutrients
- Ratio: 3 parts brown to 1 part green — too green = smelly, too brown = slow
- Turn every 1-2 weeks — aeration speeds decomposition
- Finished when dark, crumbly, earthy smell — 2-6 months depending on method

## Season Extension

- Cold frames: unheated mini greenhouse — extends season 4-6 weeks each end
- Row covers: frost protection to ~28°F/-2°C — lighter grades for pest barrier
- Mulch heavily before frost — protects roots of perennials
- Succession plant cold-hardy crops in fall — spinach, kale, garlic
- Start seeds indoors 6-8 weeks before transplant date — lighting critical

## Container Gardening

- Drainage holes mandatory — no rocks in bottom, just holes
- Potting mix, not garden soil — garden soil compacts, drains poorly in pots
- Size matters: tomatoes need 5+ gallons, herbs can use smaller
- Containers dry fast — may need twice-daily watering in heat
- Feed more frequently — nutrients wash out with watering

## Planning Principles

- Right plant, right place — sun/shade, wet/dry requirements must match site
- Group by water needs — don't mix drought-tolerant with water-lovers
- Native plants easier — adapted to local conditions, support local wildlife
- Start small, expand later — better to maintain small garden well than large garden poorly
- Keep garden journal — what worked, what failed, when planted
