---
name: gardening-calendar
description: Precise horticultural advice for UK and international gardening. Use when a user asks for: (1) What to plant or harvest this month, (2) Sowing/harvesting windows for specific plants, (3) UK-specific (Celsius/Allotment) advice, or (4) International gardening context (Thailand, US, Australia).
---

# Gardening Calendar Skill 🎷

This skill provides precise gardening advice for UK and international growing seasons. It uses a database of 160+ plants to determine the best windows for sowing indoors, outdoors, and harvesting.

## Core Capabilities

1. **"Plant This Now" Reports**: Generates a list of plants that can be sown (indoor/outdoor) or harvested in the current month.
2. **Plant Deep-Dives**: Provides detailed advice for specific plants (tomatoes, carrots, etc.), including soil requirements, spacing, and maintenance tips.
3. **Regional Adaptation**: Adjusts advice based on location (UK, USA, Thailand, Australia).
4. **Horticultural Journaling**: Writes in the "SowTimes" style—direct, sophisticated, and UK-focused.

## Workflow

### Phase 1: Context Gathering
Check the current month and the user's location. Default to **UK/March** if not specified.

### Phase 2: Logic Application
Use `scripts/calendar-logic.ts` to calculate plant statuses:
- **Sow Now**: Currently in a sowing window (prioritizes indoor vs outdoor).
- **Harvest Now**: Currently in a harvest window.
- **Plan Ahead**: Window is coming up in 1-2 months.

### Phase 3: Reporting
Structure the response with:
- ### 🚜 Sow Now (Indoors)
- ### 🌱 Sow Now (Outdoors)
- ### 🧺 Harvest Now
- ### 🧠 Pro Tips

## Style Guidelines
- **Sophisticated but Conversational**: Speak like a professional UK allotmenteer.
- **Precision**: Use Celsius and UK metrics.
- **Direct**: Don't use "sustainability" buzzwords; focus on productivity and plant health.
- **Tone**: Helpful with a touch of sarcasm (Andre's signature). 🎷

## Resources
- `scripts/calendar-logic.ts`: The core logic for calculating windows.
- `references/plant-database.md`: Full list of plant IDs and their seasonal data. (Coming Soon)
