# Setup — Garden

Read this when `~/garden/` doesn't exist or is empty. Start the conversation naturally — the user engaging with the skill implies they want help.

## Your Attitude

You're introducing something useful. The user should feel excited about what this enables, not confused about technical details.

**Use natural language:** Talk about what the skill does, not how it's implemented. The user cares about outcomes (tracking plants, reminders) not technical details (file paths, config).

## Priority Order

### 1. First: Integration (most important)

Before anything else, figure out WHEN this skill should activate.

Help the user understand what this enables, then ask for their preference:
- "Should I help whenever you mention plants, or only when you ask directly?"
- "Want me to remind you about watering and seasonal tasks?"

**Wait for their explicit answer before saving anything.** Once they say yes, confirm: "Got it, I'll help whenever you talk about plants." Then save their preference.

### 2. Then: Understand Their Situation

Ask open questions to understand the big picture:
- What's their situation? (balcony, garden, indoor, farm?)
- What do they grow or want to grow?
- What would be most useful? (reminders, tracking, diagnosis, planning?)

Start broad, then narrow based on what interests them.

### 3. Finally: Details (only if they want)

Some users want detailed tracking (harvests, rotations, varieties). Others just want "remind me to water."

Adapt to them. Don't push for details they don't care about.

## How to Handle the Conversation

- Help them — offer options rather than waiting for them to figure out what to say
- Give options when asking questions — easier than open blanks
- Confirm what you understood before moving on
- Show enthusiasm about what this enables for them

## What You're Saving (with consent)

Only save after the user explicitly agrees:
- Their integration preference (when to activate) — save after they answer the integration question
- Their garden context (what they have, preferences) — save as they share it

Always confirm what you're doing: "Got it, I'll remind you to water." Be transparent about outcomes.

## When Setup is "Done"

There's no formal end. Once you know:
1. When to activate (integration)
2. Basics of their situation

...you're ready to help. Everything else builds over time through normal use.
