# Wellbeing Management

## Burnout Detection

### Warning Signs
| Signal | Level | Action |
|--------|-------|--------|
| Score drops 2+ weeks | ⚠️ Yellow | Check sleep, suggest break |
| Skipping sessions | ⚠️ Yellow | Ask about motivation |
| Irritability reported | 🔴 Red | Recommend day off |
| Physical symptoms | 🔴 Red | Suggest medical check |
| "I can't do this" | 🔴 Red | Emotional support mode |

### Prevention Protocols

**Daily:**
- Mandatory 10min breaks every 2 hours
- One meal without studying
- 7+ hours sleep (track in sessions/)

**Weekly:**
- One half-day completely off
- Physical exercise 3x minimum
- Social time with family/friends

**Monthly:**
- One full day with zero study
- Review and celebrate progress
- Adjust unrealistic targets

## Stress Management Toolkit

### Quick Techniques (5 min)
1. **4-7-8 Breathing**: Inhale 4s, hold 7s, exhale 8s
2. **5-4-3-2-1 Grounding**: Name 5 things you see, 4 hear, 3 feel...
3. **Positive affirmation**: "I am prepared. I can handle this."

### Exam Anxiety Specific
- **Catastrophizing counter**: "Even if worst case, I have options"
- **Preparation focus**: "I control my effort, not the outcome"
- **Perspective reset**: "This is important, not life-ending"

### For Parents
- **What NOT to say**: "你一定要考好" "别人家孩子..."
- **What TO say**: "我们支持你无论结果" "休息一下吧"
- **Action**: Monitor food/sleep, not study hours

## Exam Day Protocol

### Night Before
- [ ] Stop studying by 8pm
- [ ] Prepare all materials (准考证, 身份证, 文具)
- [ ] Light dinner, no new foods
- [ ] Relaxing activity (not screens)
- [ ] Sleep by 10pm

### Morning Of
- [ ] Wake 2 hours before exam
- [ ] Familiar breakfast
- [ ] Quick flashcard review (confidence boost, not cramming)
- [ ] Arrive 30min early
- [ ] Bathroom before entering

### During Exam
- **Stuck on problem**: Skip, return later
- **Panic moment**: 10 deep breaths, then continue
- **Time pressure**: Answer all, then improve
- **Blank mind**: Start writing anything related

### Between Subjects
- DO NOT discuss answers with others
- Light snack, water
- Brief walk if possible
- Reset mentally for next subject

## Recovery Protocols

### After Bad Mock
1. Allow 24h to feel disappointed
2. Then: systematic error analysis
3. Create specific improvement plan
4. Small win the next day (easy problems)

### For Retakers (复读生)
- **Reframe failure**: "I now know exactly what to improve"
- **Comparison block**: Don't compare to peers in university
- **Focus on delta**: Track improvement from last year's score
- **Community**: Connect with other 复读生 for support

## Parent Support Guidelines

### Communication Dos
- Ask "How can I help?" not "How did you score?"
- Celebrate effort and progress, not just results
- Validate stress: "This is hard, and you're handling it"
- Offer practical help (meals, quiet space)

### Communication Don'ts
- Compare to siblings, neighbors, relatives
- Add pressure with comments about family sacrifice
- Hover or check on studying constantly
- React emotionally to score drops

### Signs Your Child Needs Professional Help
- Persistent insomnia (3+ weeks)
- Complete loss of appetite
- Self-harm thoughts or statements
- Complete withdrawal from communication

## Sleep Optimization

### Ideal Schedule
- Consistent bedtime (10-11pm)
- Wake time 7-8 hours later
- No screens 1 hour before bed
- Cool, dark, quiet room

### If Sleep Deprived
- 20min power nap (not longer)
- Caffeine cutoff at 2pm
- Don't "make up" sleep on weekends (disrupts rhythm)
