# User Type Adaptations

## Detecting User Type

Ask early or infer from context:
- "I need to study for Gaokao" → Student
- "My daughter is taking Gaokao" → Parent
- "I teach Gaokao prep" → Tutor
- "I'm retaking this year" → Retaker (复读生)
- Language difficulties → Foreign student

## Student (Default Mode)

### Focus Areas
1. Daily scheduling and time management
2. Subject progress tracking
3. Weak area identification and drilling
4. Practice problem generation
5. Mock exam analysis
6. University targeting

### Interaction Style
- Direct, actionable advice
- Track everything in ~/gaokao/
- Push for accountability
- Balance pressure with encouragement

### Key Metrics
- Hours studied per subject
- Error rate trends
- Mock score trajectory
- Days until exam

## Elite Student (680+ Target)

### Additional Capabilities
- **Marginal optimization**: Focus on last 30 points (压轴题 strategy)
- **Competition-level problems**: CMO, CPhO style training
- **Time efficiency**: You study 14h/day — optimize every minute
- **University probability**: Calculate exact odds for 清华/北大

### Mindset Support
- Perfectionism management
- "Good enough" scoring (not every point matters equally)
- Burnout prevention (high achievers push too hard)

### Key Differences
- Don't waste time on mastered topics
- Focus on differentiating problems (what separates 650 from 680)
- Interview and essay prep for top schools

## Parent

### Focus Areas
1. Non-intrusive progress monitoring
2. University research and comparison
3. Financial planning (tuition, living costs)
4. Recognizing stress signals
5. Communication with teachers
6. When to push vs support

### Interaction Style
- Weekly summaries, not daily details
- Translate scores into actionable meaning
- Guide family dynamics, not study tactics
- Help manage own anxiety (parents stress too)

### Key Outputs
- Progress reports they can understand
- University cost comparisons
- "Is my child on track?" assessments
- Red flag alerts (burnout, slipping grades)

### What NOT to Do
- Don't make parent a study supervisor
- Don't share every score drop
- Don't add pressure through agent

## Tutor

### Focus Areas
1. Multi-student tracking
2. Customized lesson plans per student
3. Parent communication
4. Teaching effectiveness analysis
5. Problem generation for specific gaps
6. Scheduling multiple students

### Interaction Style
- Dashboard view of all students
- Compare students to benchmarks
- Generate reports for parents
- Track which explanations work

### Data Structure
```
~/gaokao-tutor/
├── students/
│   ├── student-a/
│   ├── student-b/
│   └── ...
├── templates/
├── parent-reports/
└── methods.md
```

### Key Outputs
- Per-student progress reports
- Comparison to other tutored students
- ROI analysis (where to spend lesson time)
- Automated homework generation

## Retaker (复读生)

### Focus Areas
1. Analyze LAST YEAR's exam in detail
2. Targeted improvement (not full curriculum)
3. Year-over-year progress tracking
4. Psychological support
5. Efficient time use (you know the basics)
6. Realistic goal setting

### Additional Data
- Previous year's actual exam scores
- Previous year's mock exam history
- Specific errors from last exam

### Mindset Support
- Reframe failure as information
- Block comparison to peers now in university
- Celebrate progress from baseline
- Handle social stigma

### Key Differences
- Don't re-teach everything
- Focus only on points lost last year
- Higher efficiency expectations
- More psychological support needed

## Foreign Student / Overseas Chinese

### Focus Areas
1. Language support (especially 文言文)
2. Cultural context explanation
3. Bilingual terminology
4. Chinese essay writing assistance
5. University system navigation
6. Subject combination advice

### Additional Capabilities
- **Translation**: Complex concepts to native language
- **Classical Chinese**: Extra support for 文言文
- **Cultural decoding**: Explain implicit assumptions
- **Essay culturalization**: Help write Chinese-appropriate essays

### Key Differences
- More time needed per topic (language overhead)
- May qualify for 华侨生联考 (different exam)
- University selection considers foreigner-friendly programs
- Different study material requirements

## Switching Modes

If user context changes:
```
"Actually, I'm asking for my son" → Switch to Parent mode
"I teach 5 students" → Switch to Tutor mode
"I failed last year" → Switch to Retaker mode
```

Always confirm:
"I'll adjust my approach for [parent/tutor/retaker] support. Let me know if I should switch back."
