# University and Major Targeting

## Score-to-University Mapping

### National Tier System
| Tier | Score Range* | Example Universities |
|------|--------------|---------------------|
| C9联盟 | 680-750 | 清华, 北大, 复旦, 交大, 浙大, 南大, 中科大, 哈工大, 西交 |
| 985工程 | 640-680 | 同济, 武大, 中山, 厦大, 天大, 东南, 华科, 川大, 中南 |
| 211工程 | 580-640 | 上财, 央财, 对外经贸, 北邮, 华东理工, 南航, 西电 |
| 一本 | 500-580 | 双非一本, 省重点 |
| 二本 | 400-500 | 地方本科 |

*Scores vary significantly by province — always check 一分一段表

### Provincial Adjustment

Different provinces have vastly different competition:

**High Competition (difficult):**
- 河南: 1.3M test takers
- 山东: 800K test takers
- 河北, 广东, 四川

**Moderate Competition:**
- 湖北, 湖南, 江苏, 浙江
- 安徽, 江西, 福建

**Lower Competition (relatively easier):**
- 北京, 上海, 天津 (local preference)
- 西藏, 青海, 宁夏 (fewer test takers)

## Major Selection Strategy

### High-Demand Majors (高分专业)
| Major | Typical Score Premium | Career Outlook |
|-------|----------------------|----------------|
| 计算机科学 | +20-40 | ★★★★★ |
| 金融学 | +15-30 | ★★★★ |
| 临床医学 | +20-50 | ★★★★ |
| 法学 | +10-20 | ★★★ |
| 电气工程 | +10-25 | ★★★★ |

### Arbitrage Opportunities
Sometimes lower-score majors at top schools > high-score majors at worse schools:
- 清华冷门专业 (历史, 哲学) vs 普通985热门专业
- Check employment data, not just major name

### Subject Combination Requirements
| Major | Required Subject |
|-------|-----------------|
| 工科 (Engineering) | 物理 |
| 医学 | 物理 + (化学 or 生物) |
| 财经 | Any (prefer math strong) |
| 法律 | Any |
| 文史 | 历史 |

## 志愿填报 (Application Strategy)

### 平行志愿 System

Most provinces use parallel applications:
- Submit 6-12 university choices in order
- Each has 6 major preferences
- System processes top choice first, then next

### Fill Strategy

| Position | Strategy | Example |
|----------|----------|---------|
| 1-2 | 冲 (reach) | +20 above predicted score |
| 3-4 | 稳 (match) | Within ±5 of predicted |
| 5-6 | 保 (safety) | -15 below predicted |

### Critical Rules
1. **服从调剂**: Usually check yes (avoids 滑档)
2. **Research retention rates**: Some schools 调剂 to bad majors
3. **Check 招生计划**: Provincial quotas change yearly
4. **征集志愿**: Second chance if first round fails

## Score Prediction System

### Prediction Formula
```
Predicted Score = (Mock Avg) + (Trend Adjustment) + (Exam Day Factor)

Trend Adjustment:
- Rising: +5 to +15
- Stable: +0
- Falling: -5 to -10

Exam Day Factor:
- Historically calm: +5
- Historically anxious: -5
- Unknown: 0
```

### Confidence Intervals
| Mock Consistency | 90% Confidence Range |
|-----------------|---------------------|
| Very stable (±10) | Predicted ±15 |
| Moderate (±20) | Predicted ±25 |
| Volatile (±30+) | Predicted ±40 |

## Timeline for University Research

| Months Before | Activity |
|---------------|----------|
| 12 | Identify 15-20 potential universities |
| 6 | Narrow to 10, research majors |
| 3 | Visit campuses if possible |
| 1 | Finalize 6-8 with major rankings |
| Post-exam | Check 一分一段表, adjust choices |
| 填报期 | Submit final choices |

## Resources

### Key Websites
- 阳光高考网 (official admission info)
- 各省教育考试院 (provincial cutoffs)
- 大学官网招生办 (university admissions)

### Data to Collect Per University
- [ ] Last 3 years cutoff scores
- [ ] 招生计划 for your province
- [ ] Major-specific cutoffs
- [ ] 调剂 policies
- [ ] Scholarship opportunities
- [ ] Campus location and facilities
