# Study Methods

## Daily Schedule Template

### Weekday (School Day)
| Time | Activity |
|------|----------|
| 06:00-06:30 | Morning review (flashcards) |
| 06:30-07:30 | Weak subject focus |
| School hours | Classes |
| 18:00-19:00 | Dinner + break |
| 19:00-21:00 | Homework + practice |
| 21:00-22:00 | Error review + next-day prep |
| 22:00 | Sleep (non-negotiable) |

### Weekend / 复读
| Time | Activity |
|------|----------|
| 07:00-12:00 | Subject Block A (hardest subjects) |
| 12:00-14:00 | Lunch + power nap |
| 14:00-18:00 | Subject Block B |
| 18:00-19:00 | Exercise/break |
| 19:00-22:00 | Review + mock exams |

## Spaced Repetition System

### Flashcard Categories

**语文:**
- 古诗词默写 (64 required poems)
- 文言文实词/虚词
- 成语积累

**英语:**
- 3500 必考词汇
- 固定搭配
- 作文模板句

**理科:**
- 公式卡
- 概念定义
- 经典例题思路

### Review Schedule (Ebbinghaus)

| Review # | Timing |
|----------|--------|
| 1st | Same day evening |
| 2nd | Next day |
| 3rd | 3 days later |
| 4th | 7 days later |
| 5th | 15 days later |
| 6th | 30 days later |

### Flashcard File Format

`~/gaokao/flashcards/{subject}.md`:
```markdown
# 数学公式卡

## 导数
- Q: 求导法则 (乘法)
- A: (fg)' = f'g + fg'
- Last Review: 2025-02-10
- Next Review: 2025-02-13
- Difficulty: 2

## 圆锥曲线
- Q: 椭圆第二定义
- A: |PF|/|Pd| = e (焦点到准线)
- Last Review: 2025-02-08
- Next Review: 2025-02-15
- Difficulty: 4
```

## Error Analysis Method

### 1. Categorize Error Type
| Type | Description | Fix Strategy |
|------|-------------|--------------|
| **Careless** | Knew how, made mistake | Slow down, double-check |
| **Concept** | Didn't understand | Re-learn fundamentals |
| **Method** | Wrong approach | Learn correct method |
| **Time** | Ran out of time | Practice speed |
| **Novel** | Never seen this type | Expand problem bank |

### 2. Error Notebook (错题本)

For each error:
```
题目: [原题]
错误答案: [我的错误]
正确答案: [标准答案]
错误类型: [分类]
原因分析: [为什么错]
知识点: [相关知识点]
类似题: [链接到类似题目]
复习日期: [下次复习]
```

### 3. Spaced Re-practice

Wrong problems return for review:
- Day 3: Same problem
- Day 7: Similar problem (different numbers)
- Day 14: Related but harder problem

## Subject-Specific Strategies

### 数学
1. **压轴题策略**: Don't aim for full points — secure 6-8/12 first
2. **时间分配**: Multiple choice 35min, fill-in 15min, problems 70min
3. **验算习惯**: Budget 5min at end for checking

### 语文
1. **作文储备**: 10+ 万能素材, 5+ 开头模板
2. **文言文**: 120实词, 18虚词 must memorize
3. **时间分配**: 文言文 25min, 现代文 30min, 作文 50min

### 英语
1. **听力热身**: 5min before exam start
2. **阅读顺序**: Easy passages first, hard last
3. **作文公式**: Opening hook → Body paragraphs → Conclusion

## Mock Exam Strategy

### Frequency
- Full mock: 1x per month
- Subject mock: 1-2x per week
- Section practice: Daily

### Analysis Protocol
After each mock:
1. Score immediately (same day)
2. Review all errors (next day)
3. Categorize errors by type
4. Add to spaced repetition
5. Update weak area priorities
