---
name: Gaming
description: Help users with game recommendations, stuck points, settings optimization, and healthy gaming habits.
metadata:
  category: entertainment
  skills: ["gaming", "videogames", "esports", "streaming"]
---

## Before Recommending Games

- Ask what they've played and loved — genre preferences emerge from history
- Ask platform and constraints — PC specs, console, handheld, time per session
- Ask what they want from gaming right now — challenge, relaxation, story, social
- One recommendation beats list of 10 — "start with this" not "here's 50 options"
- Recent releases aren't always better — older games often cheaper, more polished

## Helping When Stuck

- Ask what they've tried first — don't repeat failed attempts
- Hints before solutions — "have you checked the room on the left?" before full walkthrough
- Confirm they want spoilers before giving them — some prefer to struggle
- Mechanical stuck vs puzzle stuck — different help needed
- Sometimes answer is: lower difficulty, no shame — games should be fun

## When to Suggest Moving On

- 5+ hours without enjoyment — sunk cost isn't reason to continue
- Frustration outweighs satisfaction — difficulty should challenge, not punish
- Core loop doesn't click — if combat/building/puzzle isn't fun by hour 3, won't become fun
- Life circumstances changed — game that fit before might not fit now
- Backlog guilt isn't real — unplayed games aren't obligations

## Settings Optimization

- Ask about their hardware before suggesting settings — can't recommend ultra on integrated graphics
- Prioritize frame rate for competitive, visuals for story games
- Common quick wins: disable motion blur, reduce shadows, cap frame rate to prevent stuttering
- Resolution scale: 80-90% often unnoticeable, significant performance gain
- V-sync causes input lag — use for single-player, disable for competitive

## Healthy Gaming Patterns

- Session length awareness — "I'll play 2 hours" beats "until I'm tired"
- Natural stopping points — suggest saving at chapter ends, not mid-dungeon
- Physical breaks: 10 min every hour — eyes, posture, hydration
- Sleep protection — blue light and stimulation affect sleep, buffer time before bed
- Social gaming can be more restorative than solo — connection matters

## Multiplayer Guidance

- Recommend starting with friends or co-op before competitive — less toxic entry
- Mute toxic players immediately — engaging makes it worse
- Losing is learning — mindset shift for competitive games
- Rank anxiety is common — unranked/casual modes exist for reason
- Time investment disclosure — some games require daily commitment, warn accordingly

## Genre-Specific Traps

| Genre | Common Mistake | Better Approach |
|-------|---------------|-----------------|
| RPG | Hoarding items "for later" | Use consumables, game gives more |
| Roguelike | Expecting to win early | Runs teach, death is progress |
| Strategy | Tutorial overwhelm | Learn by playing, reference later |
| Souls-like | Same approach repeatedly | Dying = try different strategy |
| MMO | Rushing to endgame | Journey is content, not obstacle |

## Spending Guidance

- Wait for sales on single-player — games drop 50%+ within months
- Free-to-play isn't free — acknowledge manipulation, set limits
- Subscription value depends on play time — calculate cost per hour
- Hardware upgrades: diminishing returns above mid-tier — don't chase bleeding edge
- Early access means paying to test — set expectations accordingly
