---
name: game-designer-toolkit
description: "Complete game design toolkit for creating professional GDD, game systems, level design, and prototypes. Use when: (1) Creating a new game concept or GDD, (2) Designing game systems (economy, combat, progression), (3) Planning levels and difficulty curves, (4) Writing game narratives and lore, (5) Creating game pitches or prototypes. Supports all game genres including RPG, FPS, strategy, mobile, indie, and AAA."
---

# Game Designer Toolkit

A comprehensive toolkit that transforms game ideas into professional design documents and systems. Designed for indie developers, game designers, and studios.

## Quick Start

**New game project?** Start here:
1. Tell me your game concept in a few sentences
2. I'll generate a complete GDD outline
3. We refine each section together

**Example triggers:**
- "Help me design a roguelike deck-builder"
- "Create a GDD for my mobile puzzle game"
- "Design an economy system for my RPG"

## Core Capabilities

### 1. GDD Generator (Game Design Document)

Professional GDD creation with industry-standard sections:

```
User: "Create a GDD for a cyberpunk detective game"
→ Generates complete GDD with:
  - Game Overview & Unique Selling Points
  - Target Audience & Market Analysis
  - Core Gameplay Loop
  - Mechanics & Systems
  - Characters & Story
  - Level Design Framework
  - Art & Audio Direction
  - Technical Requirements
  - Production Roadmap
```

See [references/gdd-template.md](references/gdd-template.md) for the full template structure.

### 2. Game System Designer

Design balanced, engaging game systems:

| System Type | Key Elements |
|-------------|--------------|
| **Economy** | Currency types, sinks/sources, inflation control |
| **Combat** | Damage types, balance curves, skill trees |
| **Progression** | XP curves, unlock pacing, mastery depth |
| **Social** | Multiplayer systems, guilds, trading |
| **Monetization** | F2P friendly, premium, hybrid models |

See [references/system-design.md](references/system-design.md) for detailed patterns.

### 3. Level & World Design

Create compelling spaces and pacing:

- **Level Design**: Layout principles, flow, signposting
- **Difficulty Curves**: Learning → Mastery → Challenge
- **World Building**: Biomes, points of interest, traversal
- **Pacing**: Tension/relief cycles, narrative beats

See [references/level-design.md](references/level-design.md) for frameworks.

### 4. Narrative & Quest Design

Craft engaging stories and objectives:

- Story structure (three-act, hero's journey, branching)
- Quest design patterns (fetch, escort, defend, discover)
- Dialogue systems and branching
- Lore and world consistency

### 5. Game Pitch Creator

Quick pitches for different audiences:

```
User: "Create a 30-second elevator pitch for my game"
→ Delivers: Hook + Core Loop + Differentiator + Call to Action
```

## Workflow Guide

### For New Game Concepts

1. **Concept Capture** → Gather core idea, genre, target platform
2. **GDD Generation** → Create full document structure
3. **System Design** → Define core mechanics and loops
4. **Refinement** → Iterate on each section
5. **Pitch Creation** → Distill into presentations

### For Existing Projects

1. **Audit** → Review current design docs
2. **Gap Analysis** → Identify missing elements
3. **Balance Review** → Check system interactions
4. **Documentation** → Update and standardize

## Genre-Specific Guidance

### RPG
- Character progression depth
- Branching narratives
- Loot and equipment systems
- Party/companion mechanics

### FPS/Action
- Weapon variety and balance
- Enemy AI patterns
- Map flow and chokepoints
- Skill-based matchmaking

### Strategy
- Resource management
- Tech trees and unlocks
- Asymmetric factions
- Win conditions

### Mobile/Casual
- Session length optimization
- Progression hooks
- Monetization integration
- Accessibility

### Roguelike/Roguelite
- Run variance and replayability
- Meta progression
- Build diversity
- Difficulty scaling

## Resources

### references/
- `gdd-template.md` - Complete GDD structure with examples
- `system-design.md` - Game system patterns and formulas
- `level-design.md` - Level design principles and templates

### assets/
- `gdd-template.md` - Blank GDD template for copy/use
- `pitch-deck-outline.md` - Publisher pitch structure

## Tips for Best Results

1. **Be specific about genre** - "action RPG" vs "game"
2. **Define your target audience** - Casual? Hardcore? Age range?
3. **State your platform** - Mobile, PC, console affects design
4. **Share inspirations** - "Like X meets Y" helps alignment
5. **Iterate section by section** - Better than all at once

---

*Created for game designers who want to ship faster without sacrificing quality.*
