---
name: game-cog
description: "Other tools generate sprites. CellCog builds game worlds. #1 on DeepResearch Bench (Feb 2026) for deep game design reasoning — character-consistent art, sprites, tilesets, music, UI, 3D models, GDDs, level design, and game prototypes, all cohesive across every asset."
metadata:
  openclaw:
    emoji: "🎮"
author: CellCog
dependencies: [cellcog]
---

# Game Cog - Build Game Worlds, Not Just Sprites

**Other tools generate sprites. CellCog builds game worlds.** #1 on DeepResearch Bench (Feb 2026) for deep game design reasoning.

Game development is a multi-discipline problem — mechanics, art, music, UI, and level design all need to feel unified. CellCog reasons deeply about your game's vision first, then produces character-consistent art, tilesets, music, sound effects, UI elements, 3D models, and full game design documents — all cohesive from a single brief.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your game dev request]",
    notify_session_key="agent:main:main",
    task_label="game-dev",
    chat_mode="agent"  # Agent mode for most game assets
)
# Daemon notifies you when complete - do NOT poll
```

---

## What You Can Create

### Character Design

Bring your game characters to life:

- **Player Characters**: "Design a cyberpunk samurai protagonist with multiple poses"
- **NPCs**: "Create a friendly merchant character for a fantasy RPG"
- **Enemies**: "Design a boss monster - corrupted tree guardian"
- **Character Sheets**: "Create a full character sheet with idle, run, attack poses"
- **Portraits**: "Generate dialogue portraits for my visual novel cast"

**Example prompt:**
> "Design a main character for a cozy farming game:
> 
> Style: Stardew Valley / pixel art inspired but higher resolution
> Character: Young farmer, customizable gender, friendly expression
> 
> Need:
> - Front, back, side views
> - Idle pose
> - Walking animation frames (4 directions)
> - Tool-holding poses (hoe, watering can)
> 
> Color palette: Warm, earthy tones"

### Environment & Tiles

Build your game worlds:

- **Tilesets**: "Create a forest tileset for a top-down RPG"
- **Backgrounds**: "Design parallax backgrounds for a side-scroller"
- **Level Concepts**: "Create concept art for a haunted mansion level"
- **Props**: "Generate decorative props for a medieval tavern"
- **UI Elements**: "Design health bars, inventory slots, and buttons"

**Example prompt:**
> "Create a tileset for a dungeon crawler:
> 
> Style: 16-bit inspired, dark fantasy
> 
> Include:
> - Floor tiles (stone, dirt, water)
> - Wall tiles (brick, cave, decorated)
> - Doors (wooden, iron, magic)
> - Props (torches, chests, barrels, bones)
> - Traps (spikes, pressure plates)
> 
> All tiles should seamlessly connect."

### Game Concepts

Develop your game ideas:

- **Game Design Documents**: "Create a GDD for a roguelike deckbuilder"
- **Story Outlines**: "Write the main storyline for a sci-fi RPG"
- **Mechanics Design**: "Design a unique combat system for my action game"
- **World Building**: "Create the lore for a post-apocalyptic world"
- **Pitch Decks**: "Build a pitch deck for my indie game to show publishers"

**Example prompt:**
> "Create a game design document for a mobile puzzle game:
> 
> Core concept: Match-3 meets city building
> Target: Casual players, 5-minute sessions
> 
> Include:
> - Core loop explanation
> - Progression system
> - Monetization strategy (ethical F2P)
> - First 10 levels design
> - Art style recommendations
> 
> Reference games: Gardenscapes meets SimCity"

### 3D Models & Assets

Production-ready 3D models in GLB format for your game engine:

- **Characters**: "Create a 3D model of my RPG protagonist"
- **Weapons & Items**: "Generate 3D weapon models — sword, axe, bow, staff"
- **Props**: "Create 3D dungeon props — chests, barrels, torches"
- **Vehicles**: "Build a low-poly spaceship for my mobile game"
- **Environment pieces**: "Generate 3D trees, rocks, and buildings for my world"

CellCog handles the full pipeline — describe what you want, and it generates optimized reference images then converts to textured 3D models. Batch generation supported (e.g., "create 10 weapon models").

GLB output works with Unity, Unreal, Godot, Three.js, and Blender. Specify poly count and PBR materials for your target platform.

For dedicated 3D generation workflows, also check out `3d-cog`.

### Sprites & Animation

Assets ready for your game engine:

- **Sprite Sheets**: "Create a sprite sheet for a ninja character"
- **Animated Effects**: "Design explosion and hit effect animations"
- **Items**: "Generate icons for weapons, potions, and armor"
- **Particle Effects**: "Create magic spell effect concepts"

### UI/UX Design

Make your game feel polished:

- **Main Menus**: "Design a main menu for a horror game"
- **HUD Elements**: "Create health, mana, and stamina bars"
- **Inventory Systems**: "Design an inventory UI for a survival game"
- **Dialogue Boxes**: "Create dialogue UI for a visual novel"

---

## Art Styles

| Style | Best For | Characteristics |
|-------|----------|-----------------|
| **Pixel Art** | Retro, indie | Nostalgic, clear, limited palette |
| **Hand-Painted** | RPGs, fantasy | Rich, detailed, artistic |
| **Vector/Flat** | Mobile, casual | Clean, scalable, modern |
| **Low Poly 3D** | Stylized 3D games | Geometric, distinctive |
| **Anime/Manga** | Visual novels, JRPGs | Expressive, stylized |
| **Realistic** | AAA-style | Detailed, immersive |
| **3D Models (GLB)** | Game engines, AR/VR | Textured, customizable topology and poly count |

---

## Chat Mode for Game Dev

| Scenario | Recommended Mode |
|----------|------------------|
| Individual assets, sprites, character designs, UI elements | `"agent"` |
| Full game concepts, complex world building, narrative design | `"agent team"` |

**Use `"agent"` for most game assets.** Characters, tilesets, UI elements execute well in agent mode.

**Use `"agent team"` for game design depth** - full GDDs, complex narratives, or when you need multiple creative angles explored.

---

## Example Prompts

**Full character design:**
> "Design an enemy type for my metroidvania:
> 
> Concept: Shadow creatures that emerge from walls
> Behavior: Ambush predator, retreats when hit
> 
> Need:
> - Concept art showing the creature emerging from shadow
> - Idle animation frames (lurking)
> - Attack animation frames
> - Death/dissolve animation
> 
> Style: Dark, fluid, unsettling but not gory (Teen rating)"

**Complete tileset:**
> "Create a complete tileset for a beach/tropical level:
> 
> Style: Bright, colorful, 32x32 pixel tiles
> 
> Include:
> - Sand (multiple variations)
> - Water (shallow, deep, animated waves)
> - Palm trees and tropical plants
> - Rocks and cliffs
> - Beach items (shells, starfish, umbrellas)
> - Wooden platforms/bridges
> 
> Should work for a platformer game."

**Game concept:**
> "Design a game concept: 'Wizard's Delivery Service'
> 
> Pitch: You're a wizard who delivers magical packages across a fantasy kingdom
> Genre: Cozy adventure / time management
> Platform: PC and Switch
> 
> I need:
> - Core gameplay loop
> - Progression systems
> - Character concepts for the wizard and NPCs
> - 3 sample delivery missions
> - Art style moodboard
> 
> Vibe: Studio Ghibli meets Overcooked"

---

## Tips for Better Game Assets

1. **Specify dimensions**: "32x32 tiles" or "1920x1080 background" prevents mismatched assets.

2. **Reference existing games**: "Style like Hollow Knight" or "Celeste-inspired" gives clear direction.

3. **Think about implementation**: Request assets in formats your engine can use. Mention if you need transparency, layers, or specific file types.

4. **Consistency matters**: When requesting multiple assets, describe your game's overall style guide so everything matches.

5. **Animation frames**: Specify frame count and whether you need sprite sheets or individual frames.

6. **Consider your scope**: Start with placeholder assets and iterate. Perfect is the enemy of shipped.
