# Game-Changing Features

Find 10x product opportunities and high-leverage improvements. A product strategy skill with founder mentality — not adding features, but finding the moves that 10x a product's value.

## What's Inside

- Session setup and workflow (understand current value, find opportunities, evaluate, identify leverage, prioritize)
- Three opportunity scales: Massive (transformative), Medium (force multipliers), Small (disproportionate value)
- Evaluation criteria (impact, reach, frequency, differentiation, defensibility, feasibility)
- Idea categories forcing function (Speed, Automation, Intelligence, Integration, Collaboration, Personalization, Visibility, Confidence, Delight, Access)
- Prioritization framework (Do Now, Do Next, Explore, Backlog)
- Prompts to unstick thinking
- Output format template for strategy sessions
- Database of 40 categorized opportunities in `data/opportunities.csv`

## When to Use

- User wants strategic product thinking
- User mentions "10x" or wants to find high-impact features
- User asks what would make a product dramatically more valuable
- Before major feature planning sessions

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/writing/game-changing-features
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install game-changing-features
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/writing/game-changing-features .cursor/skills/game-changing-features
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/writing/game-changing-features ~/.cursor/skills/game-changing-features
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/writing/game-changing-features .claude/skills/game-changing-features
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/writing/game-changing-features ~/.claude/skills/game-changing-features
```

## Related Skills

- **brainstorming** — For exploring and refining individual feature ideas
- **persona-docs** — Understand your users before identifying high-leverage features

---

Part of the [Writing](..) skill category.
