---
name: gallery-dl
description: Download image galleries and collections from 100+ sites. Use when: (1) Downloading from Reddit, Twitter, Instagram, Pixiv, Danbooru, (2) Batch downloading image galleries, (3) Archiving artist portfolios, (4) Downloading from specific tags or users.
version: 1.0.0
metadata:
  openclaw:
    requires:
      bins:
        - python3
    emoji: "🖼️"
    homepage: https://github.com/mikf/gallery-dl
---

# gallery-dl

Command-line tool to download image galleries from 100+ sites.

## Install

```bash
pip install gallery-dl
```

## Supported Sites

Reddit, Twitter/X, Instagram, Tumblr, Pixiv, Danbooru, Gelbooru, Furbooru, ArtStation, DeviantArt, Flickr, Newgrounds, HBO, TikTok, YouTube, and 100+ more.

## Basic Usage

```bash
# Download from URL
gallery-dl "https://www.reddit.com/r/wallpapers/"

# Download to specific folder
gallery-dl "URL" -D /path/to/folder

# Download with custom filename
gallery-dl "URL" -f "{id}.{extension}"

# Download specific user's posts
gallery-dl "https://twitter.com/username/media"

# Download from Pixiv artist
gallery-dl "https://www.pixiv.net/users/12345"

# Download from Danbooru tags
gallery-dl "https://danbooru.donmai.us/posts?tags=cat"
```

## Options

| Flag | Description |
|------|-------------|
| `-D, --directory PATH` | Download location |
| `-f, --filename FORMAT` | Filename template |
| `--range RANGE` | Download range (e.g., 1-10) |
| `--limit N` | Limit downloads |
| `--username USER` | Login username |
| `--password PASS` | Login password |
| `--netrc` | Use .netrc for auth |

## Filename Templates

```bash
# Default
gallery-dl "URL" -f "{id}.{extension}"

# By date
gallery-dl "URL" -f "{date:%Y}/{id}.{extension}"

# By site
gallery-dl "URL" -f "{domain}/{id}.{extension}"

# Original filename
gallery-dl "URL" -f "/O"
```

## Authentication

Many sites need login. Options:

1. **Command line:**
```bash
gallery-dl "URL" --username USER --password PASS
```

2. **.netrc file:**
```
machine twitter.com
login username
password password
```

3. **Config file:** `~/.config/gallery-dl/config.json`

## Configuration

Create `~/.config/gallery-dl/config.json`:

```json
{
    "extractor": {
        "twitter": {
            "username": "user",
            "password": "pass"
        },
        "pixiv": {
            "username": "user", 
            "password": "pass"
        }
    }
}
```

## Examples

```bash
# Reddit subreddit
gallery-dl "https://www.reddit.com/r/earthporn/" -D ./earthporn

# Twitter user media
gallery-dl "https://twitter.com/elonmusk/media" -D ./elon

# Pixiv artist
gallery-dl "https://www.pixiv.net/users/12345" -D ./pixiv

# Danbooru tag
gallery-dl "https://danbooru.donmai.us/posts?tags=cat" -D ./cat

# Download only first 10
gallery-dl "URL" --limit 10
```

## Extractors

Full list: https://github.com/mikf/gallery-dl#supported-services
