# CSV 导入格式规范

## 必需列名

CSV 文件必须包含以下列名（支持中英文）：

| 中文名称 | 英文名称 | 说明 |
|----------|----------|------|
| 基金代码 | fund_code | 6位基金代码 |
| 基金名称 | fund_name | 基金全称 |
| 基金账户 | fund_account | 基金账户号 |
| 交易账户 | trade_account | 交易账户号 |
| 持有份额 | holding_shares | 持有份额数量 |
| 份额日期 | share_date | 份额确认日期 |
| 基金净值 | nav | 单位净值 |
| 净值日期 | nav_date | 净值日期 |
| 资产情况（结算币种） | asset_value | 资产市值 |

## 可选列名

| 中文名称 | 英文名称 | 说明 |
|----------|----------|------|
| 基金管理人 | fund_manager | 基金公司 |
| 销售机构 | sales_agency | 销售渠道 |
| 分红方式 | dividend_method | 红利再投/现金分红 |

## 格式要求

### 文件编码

支持以下编码格式：
- UTF-8
- UTF-8 with BOM (utf-8-sig)
- GBK
- GB18030

### 日期格式

支持以下日期格式：
- `YYYY-MM-DD` (如: 2024-01-15)
- `YYYY/MM/DD` (如: 2024/01/15)
- `YYYY年MM月DD日` (如: 2024年01月15日)

### 数值格式

- 份额和资产值支持千分位分隔符
- 净值保留小数点后4位

## 示例文件

```csv
基金代码,基金名称,基金账户,交易账户,持有份额,份额日期,基金净值,净值日期,资产情况（结算币种）
004137,华夏全球精选,12345678,87654321,1000.00,2024-01-15,1.2340,2024-01-15,1234.00
000001,华夏成长,12345678,87654321,2000.00,2024-01-15,2.3450,2024-01-15,4690.00
```

## 导入命令

```bash
scripts/fund-cli.py import-csv data/holdings.csv
```

## 注意事项

1. CSV 第一行为列名行
2. 列名中的换行符会被自动处理
3. 重复导入相同记录会更新（upsert）
4. 导入前会验证数据格式