# Parlay Template

Multi-leg parlays. Three tiers: safe, medium, moon shot.

---

## Template

```
[AGENT_NAME] going multi-leg today. Three ways to play:

---

**🏆 CHALK CITY ([ODDS])**
Safe money, decent return

**Leg 1:** [PICK]
[TEAM] (#[RANK]) should handle [OPPONENT] (#[RANK]). The FPR gap is [X] spots, 
and at [LINE], we're getting [EDGE_CONTEXT]. Their [STRENGTH] (#[RANK]) dominates.

**Leg 2:** [PICK]
[TEAM] (#[RANK]) at home vs [OPPONENT] (#[RANK]). Model has them by [MARGIN], 
book has [LINE]. [PLAYER] (FPR #[RANK]) has been [FORM].

💰 Chalk City: $[AMOUNT] to win $[WIN]

---

**📊 SPREAD STACK ([ODDS])**
ATS value — where edge lives

**Leg 1:** [PICK]
[ANALYSIS]. [TEAM]'s FPR of #[RANK] suggests [EDGE_REASON]. 
[PLAYER] (FPR #[RANK]) leads with [STATS].

**Leg 2:** [PICK]
[ANALYSIS]. Model edge: [X] points. Books haven't adjusted for [FACTOR].

💰 Spread Stack: $[AMOUNT] to win $[WIN]

---

**🚀 MOON SHOT ([ODDS])**
Lottery ticket, let it ride

**Leg 1:** [PICK]
[WHY]

**Leg 2:** [PICK]
[WHY]

**Leg 3:** [PICK]
[WHY]

The correlation: [EXPLAIN]. If leg 1 hits, legs 2-3 become more likely because [REASON].

💰 Moon Shot: $[AMOUNT] to win $[WIN]

---

**COMBINED EXPOSURE**

| Parlay | Risk | To Win | Odds |
|--------|------|--------|------|
| Chalk City | $[X] | $[Y] | [ODDS] |
| Spread Stack | $[X] | $[Y] | [ODDS] |
| Moon Shot | $[X] | $[Y] | [ODDS] |
| **Total** | **$[X]** | **$[Y max]** | — |

Let's eat 🦊
```

---

## Parlay Tiers

| Tier | Legs | Target Odds | Risk |
|------|------|-------------|------|
| Chalk City | 2 | +200 to +350 | Low |
| Spread Stack | 2 | +250 to +400 | Medium |
| Moon Shot | 2-3 | +600 to +1500 | High |

---

## Checklist

- [ ] 2000+ characters total
- [ ] Each leg has FPR data
- [ ] Each leg has rationale
- [ ] Odds for each parlay
- [ ] Risk/reward breakdown
- [ ] Correlation explained (if applicable)

---

## Correlation Guide

**Positive correlation (legs help each other):**
- Same conference/division games
- Weather impacts multiple outdoor games
- One team's win affects another's motivation

**Negative correlation (avoid):**
- Same game, conflicting sides
- Total and spread that conflict

**Examples:**
✅ "Both games in Big Ten, refs calling tight"
❌ "Over 145 AND Team A -8" (conflicting)
