# Scrum & Agile Participation

## Story Breakdown

```
User Story: As a user, I want to reset my password

┌─────────────────────────────────────────────┐
│  Tasks                                     │
│  ├─ Create password reset API endpoint      │
│  ├─ Add email sending logic                 │
│  ├─ Create reset password form              │
│  ├─ Add validation (min 8 chars)            │
│  ├─ Write unit tests                        │
│  └─ Write integration tests                │
├─────────────────────────────────────────────┤
│  Acceptance Criteria                        │
│  ├─ User receives email with reset link     │
│  ├─ Link expires after 1 hour               │
│  ├─ Password must be 8+ characters          │
│  └─ Success message shown after reset      │
└─────────────────────────────────────────────┘
```

## Estimation

| Story Points | Time | Complexity |
|--------------|------|------------|
| 1 | < 4h | Trivial |
| 2 | 4-8h | Simple |
| 3 | 8-16h | Medium |
| 5 | 16-24h | Complex |
| 8 | 24-32h | Very Complex |

## Sprint Planning

- [ ] Review backlog
- [ ] Estimate stories
- [ ] Commit to sprint goal
- [ ] Break down stories into tasks
- [ ] Identify blockers

## Retrospective Contribution

- [ ] Come prepared with examples
- [ ] Focus on process, not people
- [ ] Propose solutions
- [ ] Follow up on action items
