# Full-Stack Web Engineer (Microservices & Modern Frontend)

**Owner:** @khamalismadie  
**Version:** 1.0.1  
**Distribution:** ClawHub / Public  
**Status:** Production Ready

---

## Summary

One installed skill containing 18 engineering modules. This skill is designed for Full-Stack Engineers working on:
- Modern TypeScript ecosystems
- API & distributed systems
- Microservices migration
- Frontend modernization (Vue 3)
- Legacy refactoring (PHP → TS/Bun)
- End-to-end feature ownership

## Why This Skill?

| Benefit | Description |
|---------|-------------|
| **Practical** | Real-world checklists, not theory |
| **Comprehensive** | Covers frontend to DevOps |
| **Production-Ready** | Battle-tested patterns |
| **Modern Stack** | TypeScript-first, Vue 3, Bun |

## Core Identity

**Role Level:** Mid-Level → Senior  
**Focus Area:** Full-stack architecture, performance, scalability  
**Stack Orientation:** TypeScript-first, Vue 3, API-driven systems

## Module Categories

### 🏗️ Architecture
| Module | Description | Deliverables |
|--------|-------------|--------------|
| system-design | Monolith vs Microservices, Service boundaries | Architecture Checklist, Service Mapping |
| bun-typescript | Bun runtime, TypeScript backend | Bun Project Template, TS Config |

### 🌐 API & Networks
| Module | Description | Deliverables |
|--------|-------------|--------------|
| http-grpc | REST, gRPC, idempotency, versioning | REST Checklist, gRPC Decision Matrix |
| api-development | Clean controllers, validation, auth | API Boilerplate, Error Template |

### ⚡ Performance & Resilience
| Module | Description | Deliverables |
|--------|-------------|--------------|
| performance | Bottleneck detection, caching, optimization | Performance Audit, Caching Tree |
| fault-tolerance | Retry, circuit breaker, graceful degradation | Resilience Guide, Failure Framework |

### 📊 Operations
| Module | Description | Deliverables |
|--------|-------------|--------------|
| monitoring-observability | Logging, metrics, alerting | Monitoring Checklist, Alert Rules |
| feature-flags | Safe rollout, A/B testing, kill-switches | Feature Flag Template, Rollout Framework |

### 💾 Data
| Module | Description | Deliverables |
|--------|-------------|--------------|
| sql-database | Schema, indexing, migrations | SQL Checklist, Migration Guide |
| concurrency-async | Event loop, promises, background jobs | Async Checklist, Race Condition Audit |

### 🧪 Quality
| Module | Description | Deliverables |
|--------|-------------|--------------|
| testing-fundamentals | Unit, integration, contract testing | Testing Blueprint, CI Checklist |
| code-quality | Clean code, PR standards, refactoring | Code Review Checklist, Refactor Matrix |

### 🔄 Modernization
| Module | Description | Deliverables |
|--------|-------------|--------------|
| vue3-modernization | Vue 3 Composition API, state management | Vue 3 Migration Guide, Component Patterns |
| legacy-migration | PHP → TS, strangler pattern | Legacy Audit, Extraction Plan |

### 🔧 Engineering Practices
| Module | Description | Deliverables |
|--------|-------------|--------------|
| debugging | Cross-layer debugging, production safety | Debug Workflow, RCA Template |
| scrum-agile | Sprint planning, story breakdown | Story Template, Sprint Checklist |
| cross-functional | Product communication, tech specs | Tech Spec Template, Stakeholder Framework |
| feature-ownership | End-to-end feature delivery | Feature Checklist, Release Framework |

---

## Engineering Standards

All code written under this skill must be:
- **Clear** - Easy to understand
- **Concise** - No unnecessary complexity
- **Performant** - Optimized for speed
- **Tested** - Covered by tests
- **Observable** - Has proper logging/metrics
- **Maintainable** - Well-structured
- **Backward compatible** - When applicable

## Default Principles

1. **Type Safety First** - Use TypeScript strictly, no `any`
2. **Fail Fast** - Validate early, crash loudly
3. **Optimize for Readability** - Clever is not better
4. **Prefer Explicit Over Implicit** - Clear > Short
5. **Design for Change** - Extensible architecture
6. **Ship Safely** - Feature flags, gradual rollout
7. **Document Decisions** - ADR for architectural choices

## How to Use

1. **Identify** engineering problem
2. **Load** relevant module from `references/<module>/SKILL.md`
3. **Apply** checklist
4. **Implement** framework
5. **Validate** with standards

## Quick Start

```bash
# Install via ClawHub
clawhub install fswe

# Use in your project
# Load references/fswe/SKILL.md when solving engineering problems
```

---

## Changelog

### v1.0.1
- Added owner attribution
- Enhanced module descriptions
- Added deliverable columns
- Improved engineering principles

### v1.0.0
- Initial release
- 18 engineering modules
- Practical checklists and templates
