# Frontend Design

Create memorable frontend interfaces that stand out from generic AI-generated aesthetics through bold creative choices.

## What's Inside

- Design thinking process (context, direction, memorable element)
- 10 bold aesthetic directions (Brutally Minimal, Maximalist, Retro-Futuristic, etc.)
- Typography guidelines with distinctive font pairings
- Color and theme system with CSS variables
- Spatial composition and unconventional layouts
- Motion and micro-interaction patterns
- Backgrounds and atmosphere techniques

## When to Use

- Building a new component, page, or web application
- Creating landing pages, marketing sites, or product UIs
- Redesigning interfaces to be more memorable
- Any frontend work where visual impact matters

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/frontend/frontend-design
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install frontend-design
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/frontend/frontend-design .cursor/skills/frontend-design
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/frontend/frontend-design ~/.cursor/skills/frontend-design
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/frontend/frontend-design .claude/skills/frontend-design
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/frontend/frontend-design ~/.claude/skills/frontend-design
```

## Related Skills

- `ui-design` — Fundamentals of typography, color, and spacing
- `web-design` — CSS patterns and techniques

---

Part of the [Frontend](..) skill category.
