# Friendship Conflicts

## Why Friends Fight

Unlike family (stuck together) or colleagues (professional stakes), friendships have no external glue. Conflicts feel optional to address, so they often fester.

---

## Common Conflict Types

### The Drift
Not a fight, just... fading. One person invests less over time.

**What helps:**
- Name it directly: "I feel like we've drifted. Is everything okay?"
- Propose concrete reconnection: "Let's do [specific thing]"
- Accept if they're not in a place to reciprocate

### The Slight
Something hurt you. Maybe they don't even know.

**What helps:**
- Address it before resentment builds
- Use "I felt" not "You did"
- "When [thing happened], I felt [emotion]. Was that intentional?"

### The Betrayal
They did something significant: shared a secret, crossed a line, chose someone else.

**What helps:**
- Give yourself time to calm down (24-48 hours)
- Decide what you need: apology, explanation, space, end
- Have the conversation in person if possible

### The Values Shift
You've grown apart. Political, lifestyle, or ethical differences.

**What helps:**
- Decide: Can you compartmentalize, or is this fundamental?
- Test with honest conversation about the difference
- Accept that some friendships have seasons

---

## The Repair Conversation

### Structure

1. **Ask for the conversation**
"Can we talk about something? I value our friendship and want to clear the air."

2. **State your experience (not accusation)**
"When X happened, I felt Y."

3. **Invite their perspective**
"I want to understand your side."

4. **Find resolution**
"How can we move forward?"

### What Works
- Specific, not general ("when you canceled Saturday" not "you always cancel")
- Own your reaction ("I felt hurt" not "you hurt me")
- Assume good intent until proven otherwise
- Focus on repair, not winning

### What Doesn't Work
- Bringing up old incidents
- "You always..." / "You never..."
- Expecting mind-reading
- Texting serious conversations

---

## When to Let Go

Not all friendships should be saved. Consider ending if:

- Pattern of disrespect despite conversations
- Consistently worse after spending time together
- Values conflict is fundamental (not just different)
- Trust is broken and they're not working to rebuild
- The relationship takes more than it gives, consistently

**Ending options:**
- Gradual fade (stop initiating, let it die naturally)
- Honest conversation ("I need to step back from this friendship")
- Clean break (necessary for toxic situations)

---

## After Conflict

**If repaired:**
- Don't reference the conflict repeatedly
- Give the relationship time to rebuild
- Note what led to the problem to prevent repeat

**If ended:**
- Grieve it (friendship breakups are real loss)
- Avoid badmouthing (keeps you stuck)
- Learn what you'll do differently
