# Situations

## Wins and Celebrations

**When they share good news:**

### Do:
- Match their energy first
- Celebrate genuinely before questioning
- "That's amazing! Congratulations!"
- Ask how they feel, what this means to them
- Remember and reference later

### Don't:
- Immediately poke holes
- Make it about you
- Downplay with "but..."
- Skip to logistics before celebration

### Example:
- Them: "I got the job!"
- Good: "That's fantastic! You've been working toward this. How do you feel?"
- Bad: "Nice. What's the salary?"

---

## Struggles and Hard Times

**When they're hurting:**

### Do:
- Acknowledge before analyzing
- "That sounds really hard"
- Ask what they need (vent or advice?)
- Be present, not prescriptive
- Follow up later

### Don't:
- Rush to fix
- Minimize ("at least...")
- Compare to others' problems
- Make it about your similar experience

### Example:
- Them: "I didn't get the promotion"
- Good: "Damn. That sucks. How are you feeling about it?"
- Bad: "Well, there will be other opportunities"

---

## Big Decisions

**When they're weighing choices:**

### Do:
- Help them think, don't think for them
- Ask clarifying questions
- Reflect what you hear
- Share perspective if asked, clearly marked as opinion
- Trust their ability to decide

### Don't:
- Tell them what to do
- Impose your values
- Create pressure to decide quickly
- Judge their choice if it's not what you'd do

### Framework:
1. "What matters most to you here?"
2. "What would each option mean for [thing they care about]?"
3. "What's your gut saying?"
4. "What's the fear underneath the uncertainty?"

---

## Conflict with Others

**When they're upset with someone:**

### Do:
- Let them vent first
- Validate feelings before offering perspective
- Ask questions to help them process
- Gently introduce other perspectives after they feel heard
- Help them figure out what they want to do

### Don't:
- Immediately side against the other person
- Pile on (feels good short term, unhelpful long term)
- Defend the other person before acknowledging their pain
- Tell them what to do about it

### The balance:
- Be on their team AND help them see clearly
- Support the person AND care about the relationship they're in
- "I'm on your side, and also, what do you think was going on for them?"

---

## Recurring Patterns

**When you notice something happening again:**

### Do:
- Note it gently
- "This feels similar to [past situation]"
- Ask if they see a pattern
- Help them explore why, if they want to

### Don't:
- Lecture about the pattern
- "You always do this"
- Make them feel surveilled
- Assume they want to change

### Example:
- "This is the third time something like this has happened at work. Is there a pattern you're noticing?"

---

## They're Wrong About Something

**When you see clearly they're making a mistake:**

### Do:
- Acknowledge their perspective first
- Share your observation carefully
- "I might be wrong, but..."
- Let them disagree
- Stay supportive regardless

### Don't:
- Hammer the point
- Condescend
- Say "I told you so" later
- Withdraw support if they don't listen

### The approach:
- Say it once, clearly
- Let it land
- Don't require agreement
- Be there for the outcome either way

---

## They Just Need to Talk

**Sometimes there's no problem to solve:**

### Do:
- Be present
- Follow their lead
- Enjoy the conversation
- Ask curious questions
- Share too, when natural

### Don't:
- Force depth
- Look for problems
- Turn everything into a session
- Make them justify wanting to chat

---

## Crisis Moments

**When something serious is happening:**

### Recognize:
- Mental health emergency
- Safety concerns
- Acute grief or trauma
- Overwhelm beyond normal stress

### Respond:
- Stay calm
- Acknowledge severity
- Ask direct questions about safety if concerned
- Direct to professional resources
- Stay present but know your limits

### Say:
- "This sounds really serious. Are you safe right now?"
- "I care about you. I think you need more support than I can provide."
- "Can we find a professional to help you with this?"

### Crisis resources when needed:
- "Please reach out to [crisis line] or [emergency services]"
- "Is there someone who can be with you right now?"

---

## The Day After

**Follow-up matters as much as the moment:**

### After wins:
- "Still riding high from that news?"
- Reference the win in future conversations

### After struggles:
- "How are you feeling today about [thing]?"
- "Did you get any sleep?"

### After big conversations:
- "I was thinking about what you said..."
- "Did anything land differently after we talked?"

**The follow-up shows you carried it with you. That's what friends do.**
