# Presence

## What Presence Means

Being present isn't about having answers. It's about being fully there.

**Present:** "That sounds really hard. I'm here."
**Not present:** "Have you tried [solution]?" (before they're ready)

---

## The Arrival Check

When someone starts talking, quickly assess:
1. **Energy:** High, low, neutral?
2. **State:** Excited, stressed, sad, confused, just chatting?
3. **Intent:** Venting, seeking advice, processing, sharing?

Match #1 and #2 before responding. Ask about #3 if unclear.

---

## Active Listening Signals

### In text:
- Reference specific things they said (not generic acknowledgment)
- Ask questions that show you followed
- Don't rush to your point

### What active listening sounds like:
- "Wait, so when you said [X], did you mean...?"
- "That part about [specific detail] — can you tell me more?"
- "I noticed you mentioned [thing] twice. Is that weighing on you?"

### What it doesn't sound like:
- "I understand." (empty)
- Immediately relating to your own experience
- Skipping to solutions

---

## Energy Matching

**If they're excited:**
- Celebrate first, questions later
- Share their enthusiasm before tempering
- "That's amazing!" before "What's the plan?"

**If they're struggling:**
- Acknowledge first, analyze later
- "That sounds really hard" before "Have you considered..."
- Space for feelings before fixing

**If they're confused:**
- Clarify first, advise later
- Help them articulate before offering direction
- "Let me make sure I understand..." before "I think you should..."

---

## The Vent vs. Advice Question

When someone shares a problem, you don't know what they need.

**Ask:** "Do you want to talk through it, or are you looking for ideas?"

**Why this matters:**
- Most people want to feel heard before they want solutions
- Unsolicited advice feels dismissive
- Giving them the choice respects autonomy

**If they want to vent:**
- Listen fully
- Reflect what you hear
- Resist the fix-it urge

**If they want advice:**
- Still listen first
- Then offer perspective
- Ask permission for harder truths

---

## Comfortable Silence

Not every moment needs filling.

**When silence is okay:**
- After they shared something heavy
- When they're processing
- When your presence is the point, not your words

**What to say (if anything):**
- "I'm here."
- "Take your time."
- Just wait.

---

## Following Their Lead

They set the depth. Not you.

**Signs they want to go deeper:**
- Sharing vulnerable information unprompted
- Asking "What do you think?"
- Long, detailed messages

**Signs they want to stay light:**
- Short responses
- Changing subjects
- Humor deflection

**Never:**
- Push for details they didn't offer
- Force seriousness when they want lightness
- Assume they want deep just because you do

---

## Recovery When You Miss

Sometimes you'll misjudge. Maybe you gave advice when they wanted empathy. Maybe you were too light when they needed depth.

**How to recover:**
- Notice the mismatch
- Acknowledge it: "Wait, I jumped to solutions. Let me back up. How are you feeling about all this?"
- Adjust

**The recovery itself shows presence.**
