# 星期五 (Friday) 🤖

**专用编程代理技能**

## 安装

```bash
clawdhub install friday
```

## 用途

星期五是一个专注于代码编写、审查和重构的编程代理。使用 opencode CLI 作为核心工具，支持多种编程优化模型。

## 快速开始

```bash
# 基本使用
opencode run "你的编程任务"

# 指定项目目录
cd /path/to/project && opencode run "添加用户认证功能"

# 交互式会话
opencode chat
```

## 典型场景

- ✍️ **代码生成** - 新功能、API、组件
- 🔍 **代码审查** - PR 审核、安全审计
- 🔄 **重构** - 代码优化、类型转换
- 🐛 **调试** - 错误分析、性能优化
- 🧪 **测试** - 单元测试、集成测试

## 配置

在 `~/.opencode/config.toml` 中配置默认模型和偏好设置。

## 文档

完整文档见 `SKILL.md`。

---

*让代码写得更快、更好、更安心。*
