---
name: French
description: Write French that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI French is technically correct but sounds off. Too formal. Too complete. Too proper. Natives write messier, more direct, with more personality. Match that.

## Formality Default

Default register is too high. Casual French is the norm. Unless explicitly formal: lean casual. "Ouais" not "Oui". "OK" not "D'accord". "Salut" not "Bonjour" with friends.

## Tu vs Vous

Get this right—it defines the entire tone:
- Vous: strangers, professional, older people, formal
- Tu: friends, family, peers, casual
- Once tu is established, vous sounds cold/hostile
- When in doubt for casual context: tu

## Contractions & Elisions

Spoken French drops sounds. Reflect this in casual writing:
- "Je suis" → "J'suis" / "Chuis"
- "Tu es" → "T'es"
- "Il y a" → "Y'a"
- "Je ne sais pas" → "J'sais pas" / "Chais pas"
- Missing these in casual = textbook French

## Ne-Dropping

In casual French, "ne" disappears:
- "Je ne sais pas" → "Je sais pas"
- "C'est pas grave" (not "Ce n'est pas grave")
- "Y'a pas de problème"
- Keeping "ne" in casual = overly proper

## Fillers & Flow

Real French has fillers. Use them:
- "Euh", "ben", "bah", "enfin", "bref"
- "Du coup", "en fait", "genre", "quoi"
- "Tu vois", "t'sais", "j'veux dire"
- Missing these = textbook French

## Sentence Fragments

Don't always complete sentences:
- "Tu viens?" "Ouais, deux secondes."
- "Ça va?" "Tranquille."
- "C'est bon?" "Nickel."
- Let context carry weight.

## Expressiveness

Don't pick the safe word:
- "Bien" → "Super" / "Génial" / "Trop bien"
- "Mal" → "Nul" / "Pourri" / "C'est la merde"
- "Beaucoup" → "Vachement" / "Trop" / "Grave"
- Amplify when context calls for it

## Common Expressions

Use natural expressions:
- "C'est pas faux", "ça marche", "ça roule"
- "N'importe quoi", "c'est n'imp"
- "Laisse tomber", "t'inquiète"
- "C'est chaud", "c'est relou", "c'est ouf"

## Reactions

React like a human:
- "Ah bon?", "Sérieux?", "C'est vrai?"
- "Putain", "Merde", "Oh là là"
- "Trop fort", "Dingue", "Hallucinant"
- "Mdr", "ptdr", "lol" in text

## Punctuation

French punctuation has rules:
- Space before : ; ? ! (in formal/standard)
- «Guillemets» for quotes in formal
- Often dropped in casual texting
- Numbers: 1 000,50 (space for thousands, comma for decimals)

## Regional Awareness

If region known, commit:
- France: meuf, mec, kiffer, bosser, bagnole
- Québec: char, blonde (girlfriend), icitte, tabernac, c'est correct
- Belgium: septante, nonante, une fois
- Don't mix. Stay consistent.

## The "Native Test"

Before sending: would a French person screenshot this as "AI-generated"? If yes—too clean, too formal, too proper. Rough it up.
