# Legal Considerations for AI-Assisted Freelancing

## Terms of Service Risk

| Platform | Risk Level | Key Prohibition |
|----------|------------|-----------------|
| Upwork | HIGH | Full automation, must have human-in-loop |
| Fiverr | HIGH | AI-generated profiles, deepfakes, fake engagement |
| Toptal | HIGH | No impersonation, no automated scraping |
| Freelancer | HIGH | Accounts must represent real individuals |

**Consequences:** Warning → Restriction → Suspension → Permanent Ban → Legal action

---

## Disclosure Requirements

### EU (AI Act - Article 50)
**Mandatory** disclosure when:
- Users interact with AI system
- AI-generated content published publicly
- Deepfakes or manipulated content involved

Penalties: Up to €35M or 7% global turnover.

### US
- No federal disclosure law
- FTC: Deceptive AI claims = consumer protection violation
- State laws vary (CA, IL have specific requirements)

### UK
- No specific AI disclosure law
- Consumer protection and advertising standards apply

---

## Liability Chain

```
AI Provider → Deployer (You) → Client → Third Parties
```

**You are responsible for AI output.** No "I didn't review it" defense.

### Key Cases
- **Air Canada (2024):** Company liable for chatbot misrepresentation
- **DoNotPay (2024):** FTC enforced for overpromising AI capabilities
- **Workday (2024):** AI tools can create liability even when working as intended

---

## Copyright Status

### US
- Pure AI-generated work: NOT copyrightable (public domain)
- AI-assisted with substantial human editing: Potentially copyrightable
- The more human creative input, the stronger the claim

### EU
- Similar human authorship requirement
- AI as "tool" — human author still required

### UK
- Most favorable: "Computer-generated works" can be copyrighted
- Author = person who made arrangements for creation

**Work-for-hire problem:** If AI work isn't copyrightable, there's nothing to transfer to client.

---

## Fraud Boundary

**Legitimate:** AI as acknowledged tool, disclosed, human reviewed
**Problematic:** AI does most work, undisclosed
**Fraud:** AI impersonates human identity, fake credentials

Red flags:
- Fake portfolio pieces with AI
- AI-generated reviews/testimonials
- Promising human services, delivering pure AI
- Using client data for AI training without consent

---

## Contract Law

AI can form contracts on your behalf under UETA/ESIGN:
- You're bound by AI actions within authorized scope
- Deploy AI = authorize it to act for you

Platform ToS = contract. Violating ToS with AI = breach.

---

## Recommendations

1. **Human-in-loop:** Always review AI output before delivery
2. **Disclose:** Default to transparency about AI assistance
3. **Document:** Keep records of workflow and human contributions
4. **Insurance:** Ensure coverage includes AI-assisted work
5. **EU clients:** Always disclose AI-generated components
