---
name: freelance-proposal-engine
description: Generate tailored freelance proposals for Upwork, Fiverr, Freelancer, and PeoplePerHour job listings. Use when writing proposals, bidding on gigs, or responding to client job posts.
argument-hint: "[job-description-or-url]"
allowed-tools: Read, Write, Grep, Glob, Bash, WebFetch, WebSearch
---

# Freelance Proposal Engine

Generate high-converting freelance proposals tailored to specific job listings. This skill analyzes client needs, identifies pain points, and crafts proposals that win work.

## How to Use

Provide the job listing in one of these ways:
- Paste the full job description as `$ARGUMENTS`
- Provide a URL to the listing (Upwork, Fiverr, Freelancer, etc.)
- Provide a file path containing the job description

## Proposal Generation Process

Follow these steps exactly:

### Step 1: Analyze the Job Listing

Extract and identify:
- **Client pain points**: What problem are they trying to solve?
- **Explicit requirements**: Skills, deliverables, timeline mentioned
- **Implicit requirements**: What they need but didn't say (read between the lines)
- **Budget signals**: Fixed price vs hourly, budget range if stated
- **Red flags**: Unrealistic expectations, scope creep potential, low budget
- **Client experience level**: First-time poster vs experienced buyer (review count, hire rate if visible)
- **Keywords**: Technical terms and buzzwords the client uses (mirror these back)

### Step 2: Determine Proposal Strategy

Based on analysis, select the approach:

| Client Type | Strategy |
|-------------|----------|
| First-time buyer | Reassure, explain process, offer milestone-based payment |
| Experienced buyer | Be concise, lead with results, reference similar past work |
| Technical client | Use precise technical language, skip fluff |
| Non-technical client | Translate tech into business outcomes |
| Urgent project | Lead with availability and fast turnaround |
| Budget-conscious | Emphasize value, suggest MVP/phased approach |

### Step 3: Generate the Proposal

Use this structure:

```
**Opening Hook** (1-2 sentences)
- Reference a SPECIFIC detail from their listing (proves you read it)
- Connect it to a result you've delivered before
- Never start with "I" or "My name is" or "I'm a"

**Understanding Their Problem** (2-3 sentences)
- Restate their problem in your own words
- Show you understand the WHY behind the request
- Mention one thing they might not have considered

**Your Approach** (3-5 bullet points)
- Specific steps you'll take
- Tools/technologies you'll use
- Timeline for each step
- What they'll receive at each milestone

**Relevant Experience** (2-3 sentences)
- 1-2 specific similar projects (brief, results-focused)
- Quantified outcomes where possible ("increased conversions by 40%")
- If no exact match, draw parallels from adjacent experience

**Call to Action** (1-2 sentences)
- Suggest a specific next step (quick call, share examples, start immediately)
- Create mild urgency without being pushy
- Keep it conversational
```

### Step 4: Pricing Recommendation

Based on the job analysis, suggest:
- **Your recommended rate** (based on market data and complexity)
- **Rate justification** (1 sentence)
- **Alternative pricing**: If the budget seems low, suggest a phased approach or reduced scope

Use these market rate guidelines:
| Service | Beginner | Mid-Level | Expert |
|---------|----------|-----------|--------|
| Web Development | $25-40/hr | $50-100/hr | $100-200/hr |
| Content Writing | $0.05-0.10/word | $0.10-0.25/word | $0.25-1.00/word |
| SEO | $30-50/hr | $75-150/hr | $150-300/hr |
| Web Scraping | $20-40/hr | $50-100/hr | $100-200/hr |
| Design | $25-50/hr | $50-100/hr | $100-250/hr |
| Data Analysis | $30-50/hr | $60-120/hr | $120-250/hr |
| Email Marketing | $25-40/hr | $50-100/hr | $100-200/hr |
| Social Media | $20-35/hr | $40-80/hr | $80-150/hr |

### Step 5: Output

Generate the proposal in a clean, copy-paste-ready format. Also provide:
- **Platform-specific tips** (e.g., Upwork: keep under 300 words, Fiverr: focus on deliverables)
- **Questions to ask the client** (2-3 clarifying questions that show expertise)
- **Follow-up message template** (for 48hrs after if no response)

## Proposal Quality Rules

1. **Never be generic**. Every sentence must reference something specific from the listing.
2. **Never oversell**. Confidence without arrogance.
3. **Never lie about experience**. If you lack direct experience, say "I haven't done X specifically, but I've done Y which involves the same skills."
4. **Keep it scannable**. Clients review 20-50 proposals. Use short paragraphs and bullet points.
5. **Word count**: 150-300 words for simple jobs, 300-500 for complex ones. Never more.
6. **No templates phrases**: Ban "I am writing to express my interest", "I am confident that", "I look forward to hearing from you", "Dear Sir/Madam", "I have X years of experience."

## Example

**Job listing**: "Need someone to scrape product data from 5 e-commerce sites. Need product name, price, description, images. CSV output. ~500 products per site."

**Generated proposal**:

> Scraping 2,500 products across 5 e-commerce sites with clean CSV output — I've done this exact type of project multiple times.
>
> Here's how I'd handle this:
>
> - **Day 1**: Build scrapers for all 5 sites using Python + Playwright (handles JavaScript-rendered pages that simpler tools miss)
> - **Day 2**: Run extraction, clean and normalize the data (consistent formatting across all 5 sources)
> - **Day 3**: Deliver final CSVs with columns for product name, price, description, and image URLs
>
> A few things that'll save you headaches: I'll handle pagination automatically, add retry logic for flaky pages, and deduplicate any products that appear in multiple categories.
>
> Last month I scraped 15,000+ SKUs from three competitor sites for a retail client — delivered in 48 hours with 99.7% accuracy.
>
> Quick questions: Are any of these sites behind a login? And do you need this as a one-time scrape or recurring?
>
> I can start today if the details check out.
