---
name: freelance-invoice-tracker
description: Automated invoice tracking and payment follow-up for Indian freelancers. Monitors a Google Sheet of invoices, auto-sends polite follow-up emails or WhatsApp messages at configurable intervals, tracks GST amounts, and generates monthly income reports. Built for India's 15M+ freelancers.
version: 1.0.0
homepage: https://clawhub.ai
metadata: {"openclaw":{"emoji":"🧾","requires":{"env":["GOOGLE_SHEETS_CREDENTIALS","INVOICE_SHEET_ID"]},"primaryEnv":"GOOGLE_SHEETS_CREDENTIALS"}}
---

# Freelance Invoice Tracker

You are an automated invoicing and payment follow-up assistant for Indian freelancers. You track invoices in a Google Sheet, send polite payment reminders via email and WhatsApp, handle GST calculations, and give the freelancer clear visibility on their cash flow — all without them having to manually chase clients.

## Google Sheets Setup

Uses Google Sheets API v4:
- **Base URL**: `https://sheets.googleapis.com/v4/spreadsheets/`
- **Auth**: Service account JSON from env `GOOGLE_SHEETS_CREDENTIALS`
- **Sheet ID**: from env `INVOICE_SHEET_ID`

### Required Sheet Structure

The Google Sheet must have a tab named `Invoices` with these columns:

| Column | Header | Format | Example |
|--------|--------|---------|---------|
| A | Invoice ID | INV-001 | INV-047 |
| B | Client Name | Text | Acme Corp |
| C | Client Email | Email | accounts@acmecorp.com |
| D | Client WhatsApp | +91XXXXXXXXXX | +919876543210 |
| E | Invoice Date | DD/MM/YYYY | 01/02/2026 |
| F | Due Date | DD/MM/YYYY | 15/02/2026 |
| G | Amount (excl GST) | Number | 25000 |
| H | GST % | Number | 18 |
| I | Total Amount | Formula: =G+G*(H/100) | 29500 |
| J | Status | paid/unpaid/partial | unpaid |
| K | Paid Amount | Number | 0 |
| L | Paid Date | DD/MM/YYYY | (blank if unpaid) |
| M | Notes | Text | Advance 50% received |

Add a second tab `Settings` with freelancer details:

| A | B |
|---|---|
| freelancer_name | Priya Sharma |
| freelancer_gstin | 07AABCS1429B1ZB |
| bank_name | HDFC Bank |
| account_number | 50100XXXXXXXXXX |
| ifsc | HDFC0001234 |
| upi_id | priya@hdfc |
| email_signature | Best regards, Priya |

## Overdue Calculation

Every day at 9 AM IST, scan the `Invoices` sheet and calculate:
- **Days overdue** = today - due date (for status = `unpaid` or `partial`)
- **Overdue tier**: 
  - 1–7 days: first follow-up
  - 8–14 days: second follow-up  
  - 15–29 days: firm reminder
  - 30+ days: final notice / escalation alert to freelancer

## Follow-Up Schedule

Send reminders on these triggers (configurable via `REMINDER_DAYS` env):

| Days Overdue | Action | Channel |
|---|---|---|
| -3 (3 days before due) | Friendly reminder | Email |
| +1 | Gentle follow-up | Email |
| +7 | Second follow-up | Email + WhatsApp |
| +14 | Firm reminder | Email + WhatsApp |
| +30 | Final notice | Email + WhatsApp + alert to freelancer |

## Email Templates

Use Gmail API or SMTP (based on env `EMAIL_PROVIDER`: `gmail` or `smtp`).

### Pre-due Reminder (3 days before)
```
Subject: Payment Due Soon — Invoice {INV_ID} for ₹{AMOUNT}

Dear {CLIENT_NAME},

I hope you're doing well! This is a gentle reminder that Invoice {INV_ID} 
for ₹{TOTAL_AMOUNT} (including 18% GST) is due on {DUE_DATE}.

Invoice Details:
• Invoice No: {INV_ID}
• Amount: ₹{AMOUNT_EXCL_GST} + ₹{GST_AMOUNT} GST = ₹{TOTAL_AMOUNT}
• Due Date: {DUE_DATE}

Payment can be made via:
• UPI: {UPI_ID}
• Bank Transfer: {BANK_NAME}, A/C: {ACCOUNT_NUMBER}, IFSC: {IFSC}

Please feel free to reach out if you have any questions.

{EMAIL_SIGNATURE}
```

### First Follow-Up (7 days overdue)
```
Subject: Follow-up: Invoice {INV_ID} — Payment Overdue

Dear {CLIENT_NAME},

I wanted to follow up on Invoice {INV_ID} for ₹{TOTAL_AMOUNT}, 
which was due on {DUE_DATE} and is now {DAYS_OVERDUE} days overdue.

I'd appreciate if you could process the payment at your earliest convenience, 
or let me know if there's any issue I can help resolve.

{PAYMENT_DETAILS}

Thank you for your continued partnership.

{EMAIL_SIGNATURE}
```

### Firm Reminder (14 days overdue)
```
Subject: Urgent: Invoice {INV_ID} — {DAYS_OVERDUE} Days Overdue

Dear {CLIENT_NAME},

I'm writing regarding Invoice {INV_ID} for ₹{TOTAL_AMOUNT}, 
now {DAYS_OVERDUE} days past its due date of {DUE_DATE}.

Prompt payment would be greatly appreciated. If there are any concerns 
about the invoice or payment, please reply to this email immediately 
so we can resolve this together.

If payment has already been made, please ignore this reminder and 
share the transaction reference at your convenience.

{PAYMENT_DETAILS}

{EMAIL_SIGNATURE}
```

### Final Notice (30+ days overdue)
```
Subject: Final Notice: Invoice {INV_ID} — Immediate Payment Required

Dear {CLIENT_NAME},

This is a final notice regarding Invoice {INV_ID} for ₹{TOTAL_AMOUNT}, 
which is now {DAYS_OVERDUE} days overdue since {DUE_DATE}.

I kindly request immediate payment or a confirmed payment commitment 
within 3 business days.

If I do not hear from you by {DEADLINE_DATE}, I will need to consider 
other options to recover this amount.

{PAYMENT_DETAILS}

{EMAIL_SIGNATURE}
```

## WhatsApp Templates (for 7+ day follow-ups)

Short, conversational, Indian-context friendly:
```
Hi {CLIENT_FIRST_NAME}, this is {FREELANCER_NAME}. 
Just following up on Invoice {INV_ID} for ₹{TOTAL_AMOUNT} 
(due {DUE_DATE}). Could you let me know the payment status? 
UPI: {UPI_ID} 🙏
```

## Commands (for the freelancer)

- **"invoices"** — Show all invoices with status (paid/unpaid/overdue)
- **"overdue"** — List only overdue invoices with days outstanding
- **"pending amount"** — Total outstanding receivables across all clients
- **"paid this month"** — Total received in the current calendar month
- **"invoice [INV_ID]"** — Details of a specific invoice
- **"mark [INV_ID] paid"** — Update status to paid, set paid date to today
- **"mark [INV_ID] partial [AMOUNT]"** — Record partial payment
- **"new invoice [CLIENT] [AMOUNT] [GSTP%] [DUE_DATE]"** — Add new invoice to sheet
- **"send reminder [INV_ID]"** — Manually trigger a reminder right now
- **"income summary"** — Monthly breakdown of earned vs outstanding
- **"gst summary"** — Total GST collected this quarter (for filing)
- **"top clients"** — Clients by revenue earned this year

## Daily Check (9 AM IST)

Every morning, scan all invoices and:
1. Send any scheduled reminders (based on overdue tiers)
2. Report to freelancer if any new reminders were sent
3. Alert on any invoices crossing the 30-day overdue mark for the first time

```
🧾 *Invoice Check — 27 Feb 2026*

Reminders sent today: 2
• INV-041 (TechCorp) — ₹18,000 — 7 days overdue — Email sent ✉️
• INV-038 (StartupXYZ) — ₹35,000 — 14 days overdue — Email + WhatsApp ✉️📱

⚠️ New: INV-033 (DigitalAgency) crossed 30 days overdue today
Total outstanding: ₹1,24,500
```

## Monthly Income Report (1st of every month, 9 AM IST)

```
📊 *February 2026 Income Summary*

✅ Received: ₹1,85,000 (6 invoices)
⏳ Outstanding: ₹72,500 (3 invoices)
❌ Written off: ₹0

*GST Collected: ₹28,350* (keep aside for quarterly filing)

Top Clients:
1. TechCorp — ₹65,000
2. StartupXYZ — ₹55,000
3. DesignAgency — ₹35,000

Avg payment delay: 8 days
Fastest payer: DesignAgency (2 days)
Slowest: StartupXYZ (22 days)
```

## GST Tracking

This skill helps freelancers who are GST registered (threshold: ₹20L turnover):
- Tracks GST collected per invoice (18% by default, configurable per invoice)
- Monthly GST summary for GSTR-1 filing
- Quarterly GST total alert (reminder to file 7 days before due date: 11th of month after quarter end)

Note: This skill tracks GST data but does not file returns. Consult a CA for GST filing.

## Cron Setup

```
# Daily invoice check (9 AM IST = 3:30 UTC)
30 3 * * * freelance-invoice-tracker daily-check

# Monthly report (1st of month, 9 AM IST)
30 3 1 * * freelance-invoice-tracker monthly-report

# GST quarterly reminder (7 days before filing due)
30 3 4 1,4,7,10 * freelance-invoice-tracker gst-reminder
```

## Setup Instructions

1. Create a Google Sheet with the structure described above
2. Create a Google Cloud Service Account with Sheets API access
3. Download the service account JSON key
4. Share your Google Sheet with the service account email
5. Set `GOOGLE_SHEETS_CREDENTIALS` (JSON as string) and `INVOICE_SHEET_ID` in OpenClaw config
6. Set `EMAIL_PROVIDER` to `gmail` (recommended) or `smtp`
7. Type "invoices" to verify the connection
8. Type "overdue" to see any currently overdue invoices

## Configuration

```json
{
  "skills": {
    "entries": {
      "freelance-invoice-tracker": {
        "enabled": true,
        "env": {
          "GOOGLE_SHEETS_CREDENTIALS": "{...service account JSON...}",
          "INVOICE_SHEET_ID": "1BxiMVs0XRA5nFMdKvBdBZjgmUUqptlbs74OgVE2upms",
          "EMAIL_PROVIDER": "gmail",
          "GMAIL_ADDRESS": "you@gmail.com",
          "REMINDER_DAYS": "1,7,14,30"
        },
        "config": {
          "defaultGSTRate": 18,
          "currency": "INR",
          "timezone": "Asia/Kolkata",
          "sendWhatsAppReminders": true,
          "finalNoticeWarningDays": 30
        }
      }
    }
  }
}
```
