---
name: Founder
description: Build startups with product-market fit, fundraising, team building, and founder resilience.
metadata: {"clawdbot":{"emoji":"🚀","os":["linux","darwin","win32"]}}
---

# Founder Assistance Rules

## Early Stage
- Talk to customers before building — assumptions are usually wrong
- Problem validation before solution validation — make sure it's worth solving
- MVP means embarrassingly small — ship the smallest thing that tests your hypothesis
- Speed of learning beats quality of product early on
- Choose co-founders like marriage — complementary skills, aligned values, tested under stress

## Product-Market Fit
- Users that would be "very disappointed" without you — that's the metric (40%+ threshold)
- Retention matters more than acquisition — leaky bucket never fills
- Pull beats push — customers seeking you out vs you convincing them
- PMF feels like demand you can barely keep up with
- Before PMF, nothing else matters — don't scale what doesn't work

## Fundraising
- Raise when you have momentum, not desperation
- Know your numbers cold — ARR, growth rate, burn, runway, unit economics
- VCs pattern-match — know what pattern you fit
- SAFE vs priced round: tradeoffs on both sides
- 100 meetings to find 1 yes is normal — rejection isn't signal about your company

## Team
- First 10 hires define culture — choose carefully
- Hire for slope over experience early — fast learners beat credentialed operators
- Fire fast when it's not working — one bad hire poisons teams
- Equity is precious — be generous but not careless
- Founder doing everything doesn't scale — delegate before breaking

## Execution
- Focus is saying no to good ideas — not just bad ones
- Metrics: one north star, 2-3 supporting — more means no focus
- Weekly cadence: set goals, execute, review, repeat
- Ship > perfect — iterate based on feedback
- Default to action — analysis paralysis kills startups

## Pivoting
- Pivot on strategy, not vision — the problem matters, your solution might not
- Data tells you what isn't working — customers tell you what might
- Pivots require conviction — half-pivots fail
- Runway determines pivot options — pivot with 18 months, not 3
- Kill projects before they kill you — sunk cost is sunk

## Survival
- Cash is oxygen — know your runway in weeks, not months
- Revenue solves most problems — paying customers validate everything
- Cut costs in chunks, not slices — small cuts demoralize without saving
- Down rounds happen — survive now, optimize later
- Mental health isn't optional — burnout helps nobody

## Founder Psychology
- Imposter syndrome is universal — you're not uniquely unqualified
- The highs are too high, the lows are too low — regression to mean happens
- Find founder peers — they understand what others can't
- Separate identity from company — you're not your startup
- Ask for help — everyone does, they just don't advertise it

## Common Mistakes
- Building in stealth too long — the idea isn't the moat
- Hiring senior too early — expensive people need infrastructure
- Chasing press over customers
- Raising too much and losing discipline — constraints breed creativity
- Optimizing for valuation over progress
