# Coaching Question Banks

Categorized questions for every founder coaching scenario.

## Opening Questions

### Start Any Session

- "What's on your mind?"
- "What would you like to focus on today?"
- "What would make this conversation most useful for you?"
- "What's the most important thing we should discuss?"

### After Any Response

- "And what else?" (The magic question - use 3-5 times)
- "What makes that feel important right now?"
- "Say more about that."

### Getting to the Real Issue

- "What's the real challenge here for you?"
- "If you could only solve one thing today, what would it be?"
- "What's beneath that?"

## Strategic Decisions

### Clarifying the Decision

- "What are you actually deciding between?"
- "What would you need to know to make this decision confidently?"
- "What's the cost of not deciding?"
- "When does this decision need to be made by?"

### Examining Options

- "What are all the options you see?"
- "What else?" (repeat 3-5 times)
- "If you couldn't fail, which would you choose?"
- "What would you advise a friend to do?"
- "What's the option you're afraid to consider?"

### Testing Assumptions

- "What are you assuming about Option A?"
- "What would need to be true for Option B to work?"
- "What would change if that assumption were wrong?"
- "What evidence supports your current thinking?"
- "What would a skeptic say?"

### Evaluating Trade-offs

- "What are you optimizing for?"
- "If you say yes to this, what are you saying no to?"
- "What's the best case? Worst case? Most likely case?"
- "What would you regret not trying?"
- "How would you explain this decision to yourself in a year?"

### Building Confidence

- "What criteria matter most here?"
- "What information would help you decide?"
- "How will you know if it was the right call?"
- "What's the smallest version of this you could test?"

## When Founder Is Stuck

### Identifying the Block

- "What's stopping you?"
- "What are you avoiding?"
- "What feels heavy about this?"
- "Where do you feel most stuck?"
- "What would have to change for you to move forward?"

### Shifting Perspective

- "What would you do if you had unlimited resources?"
- "What would [person they admire] do in this situation?"
- "If you knew you couldn't fail, what would you try?"
- "What's the simplest possible next step?"
- "What would you do if you only had one month left?"

### Finding Past Solutions

- "When have you faced something similar? What did you do?"
- "Tell me about a time you overcame a similar challenge."
- "What's worked for you before in situations like this?"
- "What strengths do you have that could help here?"

### Breaking the Pattern

- "What's one thing you could do differently this time?"
- "What's the smallest experiment you could run?"
- "What if you tried the opposite of what you've been doing?"
- "What would happen if you just did nothing?"

## Prioritization

### Identifying What Matters

- "If you could only accomplish one thing this week, what would it be?"
- "What would move the needle most?"
- "What's urgent vs. what's important?"
- "What would happen if you didn't do any of these things?"

### Creating Focus

- "What are you saying yes to that you should say no to?"
- "What would a ruthless prioritizer do here?"
- "If your runway were halved, what would you cut?"
- "What's the one thing that, if you did it, would make everything else easier?"

### Managing Trade-offs

- "What's the cost of doing everything?"
- "What balls can you let drop?"
- "What's good enough vs. what needs to be perfect?"
- "Who else could do this?"

## Customer Development

### Understanding the Problem

- "What problem are you solving?"
- "How do you know this is a real problem?"
- "Who has this problem most acutely?"
- "How are they solving it today?"

### Validating with Users

- "How many users have you talked to this week?"
- "What did you learn?"
- "What surprised you?"
- "What did they say in their own words?"

### Getting to Truth

- "What would prove you wrong?"
- "What would make someone pay for this?"
- "What are users actually doing vs. what they say they want?"
- "What's the strongest objection you've heard?"

### Building Confidence

- "How many people would need to say yes for you to be confident?"
- "What's the smallest experiment to test this?"
- "What would 'enough' validation look like?"

## Fundraising

### Timing

- "Why raise money now?"
- "What would you do with the money specifically?"
- "How does this accelerate vs. bootstrap?"
- "What happens if you don't raise?"

### Preparation

- "What's your story?"
- "Why you? Why now? Why this?"
- "What's the biggest risk, and how are you addressing it?"
- "What milestones would you hit with this round?"

### Strategy

- "Who are the right investors for this stage?"
- "What's your target? What's your walk-away?"
- "How many conversations do you need to get one yes?"
- "What's your plan B if this round doesn't close?"

### Alternatives

- "What would you do if you couldn't raise?"
- "How could you extend runway without dilution?"
- "What grants or non-dilutive options exist?"
- "Could you get to revenue faster instead?"

## Runway & Cash

### Understanding the Situation

- "What's your current runway?"
- "What's your monthly burn?"
- "What's driving the burn?"
- "When did you last calculate this?"

### Creating Options

- "How could you cut burn by 30%?"
- "What could you charge for today?"
- "What would you do if runway were half what it is?"
- "What's the path to breakeven?"

### Making Decisions

- "What would you cut if you had to choose?"
- "What's the minimum viable team?"
- "What's essential vs. nice to have?"
- "What would a default alive version look like?"

## Team & Hiring

### Timing

- "Why hire now vs. wait?"
- "What work isn't getting done that this person would do?"
- "Could you outsource this instead?"
- "What's the cost of not hiring?"

### Role Definition

- "What does success look like in 90 days?"
- "What skills are absolutely required vs. nice to have?"
- "What would this person do in their first week?"
- "How would you know they're performing well?"

### Fit

- "What kind of person thrives at this stage?"
- "What values matter most?"
- "What would be a red flag?"
- "How will you evaluate culture fit?"

### Co-Founder

- "What would a co-founder do that you can't?"
- "What's the risk of staying solo?"
- "What qualities would complement yours?"
- "How would you structure the relationship?"

## Product Development

### Direction

- "What's the most important thing to build next?"
- "How do you know that's what users want?"
- "What's the smallest version that would be useful?"
- "What would you cut if you had to ship in half the time?"

### Quality vs. Speed

- "What's good enough for this stage?"
- "What are you over-engineering?"
- "What bugs can you live with?"
- "What would embarrass you vs. what would just be imperfect?"

### Technical Debt

- "What's slowing you down?"
- "What would happen if you didn't fix this?"
- "What's the cost of fixing it now vs. later?"
- "Is this actually blocking progress, or is it bothering you?"

## Fear & Self-Doubt

### Acknowledging the Emotion

- "What are you afraid of?"
- "What's the worst that could happen?"
- "And then what would happen?" (Keep asking)
- "How bad would that actually be?"

### Finding Evidence

- "What evidence contradicts your fear?"
- "When have you overcome something like this before?"
- "Who believes in you? What do they see?"
- "What would you tell a friend who felt this way?"

### Building Courage

- "What would you attempt if you knew you couldn't fail?"
- "What's one small step you could take despite the fear?"
- "What's the cost of not acting?"
- "What would you regret not trying?"

### Reframing

- "What could this experience teach you?"
- "How might this make you stronger?"
- "What's the opportunity hidden in this challenge?"
- "What would future you thank you for doing now?"

## Burnout & Overwhelm

### Assessing the Situation

- "How are you really doing?"
- "When did you last feel energized?"
- "What's draining you most?"
- "What are you not making time for?"

### Creating Space

- "What would happen if you took a day off?"
- "What could you stop doing?"
- "What would you do if you weren't doing this?"
- "Who could help carry some of this?"

### Finding Renewal

- "What recharges you?"
- "What did you used to enjoy that you've stopped doing?"
- "What would feel like a treat right now?"
- "What would 'sustainable' look like for you?"

### Getting Support

- "Who can you talk to about this?"
- "What support do you need?"
- "What would help right now?"
- "Have you considered talking to someone professional?"

## Accountability

### Setting Commitments

- "What will you do?"
- "When exactly will you do it?"
- "How will you know it's done?"
- "On a scale of 1-10, how committed are you?"
- "What would make it a 10?"

### Anticipating Obstacles

- "What might get in the way?"
- "What's happened before when you tried this?"
- "How will you handle that?"
- "What's your backup plan?"

### Following Up

- "What did you commit to last time?"
- "What actually happened?"
- "What did you learn?"
- "What got in the way?" (If incomplete)
- "What will you do differently?"

## Closing Questions

### Consolidating Learning

- "What was most useful for you today?"
- "What are you taking away from this conversation?"
- "What shifted for you?"
- "What will you do differently as a result?"

### Building Forward

- "What's your commitment for the next 48 hours?"
- "What support do you need?"
- "What should we talk about next time?"
- "Anything else we should cover before we wrap?"

## Meta Questions

### About the Coaching

- "What would make these conversations more useful?"
- "What kind of support is most helpful right now?"
- "What am I missing?"
- "What question should I be asking that I'm not?"

### About Thinking Process

- "How are you approaching this decision?"
- "What's your thinking process here?"
- "What questions are you asking yourself?"
- "What would help you think more clearly?"

### About Patterns

- "What patterns do you notice in yourself?"
- "When do you do your best thinking?"
- "What triggers you to get stuck?"
- "What have you learned about how you work best?"
