# Weekly Challenge System

The weekly challenge system helps founders internalize mental models and create real business progress through deliberate practice and action-oriented tasks.

## 1. Challenge Types

### 1.1 Mental Model Practice
- **Definition**: Select one mental model (see `references/mental-models/`) and apply it deliberately in conversations, decisions, or daily work this week.
- **Goal**: Shift default thinking patterns and build stronger decision frameworks.
- **Examples**:
  - "This week I will use First Principles to re-evaluate our pricing strategy."
  - "This week I will practice Nonviolent Communication in every team meeting."

### 1.2 Action Task
- **Definition**: A concrete, measurable, challenging task that can be completed within the week.
- **Goal**: Produce real business output or unlock critical learning.
- **Examples**:
  - "Complete 5 in-depth interviews with potential customers."
  - "Publish one industry-insight blog post."
  - "Reduce core workflow response time by 20%."

## 2. Challenge Lifecycle

1. **Created**: The user requests a challenge. The coach helps define the goal, type, and deadline.
2. **In Progress**: The challenge is active. The coach observes conversations and records evidence.
3. **Completed**: The user reports completion. The coach confirms and guides reflection.
4. **Abandoned**: The user chooses to stop due to priorities or external constraints.

## 3. Trigger Mechanism

- **User-initiated only**: The system does **not** push challenges automatically.
- **Example triggers**:
  - "Help me set a challenge for this week."
  - "I want to challenge myself this week."
  - "Please track my goal for this week."

## 4. Tracking and Verification

- **User updates**: The user reports progress or completion in conversation.
- **AI observation**: The coach detects evidence of mental model application or task execution.
- **Weekly review**: On Sunday (or Monday), the coach prompts a brief reflection on challenge status.

## 5. Storage Format

Challenges are stored in the `challenges` section of the user's `founder-profile.md` using the format defined in `assets/challenge-template.md`.
