# NFX Mental Models for Founders

These mental models are curated from NFX's startup playbook, designed to help founders make higher-quality decisions in highly uncertain environments.

## 1. Goldilocks Zone
**Description:** The right answer is rarely at either extreme; it's usually in the middle. But this isn't mediocre compromise—it's precise balance.
**Usage Scenario:** When making decisions about pricing, team size, or product complexity.
**Sample Questions:**
- Is our strategy too aggressive to be sustainable, or too conservative to break through?
- Where is the "sweet spot" that maintains growth speed without breaking the organization?

## 2. 11 of 13 Rule
**Description:** Out of 13 possible strategies, perhaps 11 are effective. The key isn't finding the one "perfect strategy," but choosing one and executing it to the extreme.
**Usage Scenario:** When hesitating between multiple growth channels or product directions.
**Sample Questions:**
- Are we wasting too much time searching for the "best" path?
- What would happen if we just picked one now and committed all resources to it?

## 3. Rational Prison
**Description:** Break the assumption of pure rationality. In human behavior and market competition, irrational forces often outweigh rational ones.
**Usage Scenario:** When building brand, analyzing user psychology, or formulating competitive strategy.
**Sample Questions:**
- Are our assumptions based on users being "completely rational"?
- What emotional drivers are we currently completely ignoring?

## 4. Speed vs Quality Matrix
**Description:** Not everything needs high quality. Distinguish between "reversible decisions" and "irreversible decisions," and pursue extreme speed on reversible ones.
**Usage Scenario:** When allocating resources or prioritizing feature development.
**Sample Questions:**
- If we make the wrong decision, can we easily roll it back?
- Are we over-polishing details that don't affect the big picture?

## 5. White-Hot Center
**Description:** Find the core users who have extreme desire (white-hot need) for your product, rather than trying to please everyone.
**Usage Scenario:** When launching a product cold or defining your core audience.
**Sample Questions:**
- Which small group would be unable to work today without our product?
- Have we diluted value to core users by trying to please edge users?

## 6. Go Full Speed
**Description:** Speed is the startup's only, absolute advantage against large companies. Once you hesitate, the advantage is lost.
**Usage Scenario:** When executing plans, expanding markets, or responding to competition.
**Sample Questions:**
- If we had to cut this project's timeline in half, what would we need to stop doing?
- Which link in our current decision chain is slowing us down the most?

## 7. Network Effects
**Description:** Every new user adds value to existing users. This is the most powerful way to build a moat.
**Usage Scenario:** When designing business models or analyzing long-term competitive advantage.
**Sample Questions:**
- As user count increases, does our product become more useful or more bloated?
- How can we design connections between users to create additional value?

## 8. Critical Mass
**Description:** The minimum user base required to activate network effects. Before reaching this point, growth is extremely difficult.
**Usage Scenario:** When planning market launch or evaluating growth bottlenecks.
**Sample Questions:**
- In this specific market/vertical, how many users do we need for self-sustaining growth?
- Are we blindly expanding now, or focused on conquering a specific critical point?

## 9. Information Asymmetry
**Description:** Leverage your deep insight into a particular vertical or unique technology to create advantage.
**Usage Scenario:** When searching for startup ideas or defining core competitiveness.
**Sample Questions:**
- What truths about this industry do only we know that others haven't realized yet?
- How do we convert this information advantage into a product moat?

## 10. The Knowledge/Learning Curve
**Description:** An organization's execution ability depends on its speed of learning and iteration.
**Usage Scenario:** When managing teams or establishing review systems.
**Sample Questions:**
- When was the last time we learned key knowledge from a failure?
- How long is our experiment cycle (hypothesis-execution-feedback)?

## 11. Compounding
**Description:** Persistently doing the right small things over the long term produces exponential growth in effect.
**Usage Scenario:** When analyzing brand, culture building, or user retention.
**Sample Questions:**
- Which work accumulates advantages over time rather than being consumptive?
- Are we sacrificing long-term compounding growth by pursuing short-term bursts?

## 12. Default Alive vs. Default Dead
**Description:** Assuming no fundraising, how long can the company survive? Clearly recognize your financial and growth status.
**Usage Scenario:** When controlling fundraising pace and cash flow management.
**Sample Questions:**
- At current spending and revenue growth rates, how far are we from break-even?
- Are our current actions increasing survival probability or accelerating death?
