# 4Ps Framework: Getting Unstuck

When founders feel "stuck" or experience slow progress in the search for Product-Market Fit (PMF), the 4Ps framework provides clear diagnostic dimensions to help re-examine the core of the business.

## Core Dimensions

### 1. Persona
**Who benefits most from your insight?**

- The goal is not just to define a broad market, but to find the "super users" who most urgently need your solution.
- **Sample Questions:**
  - If your product disappeared tomorrow, who would suffer the most?
  - Which users are already trying to solve this problem with various "hacky workarounds" without your product?

### 2. Problem
**Is this problem urgent and important?**

- Distinguish between "painkillers" (addressing burning needs) and "vitamins" (long-term improvements). In the early stages, solving a pain point that keeps users up at night is crucial.
- **Sample Questions:**
  - Would users be willing to pay immediately or change their existing workflow to solve this problem?
  - Where does solving this problem rank on the user's current priority list?

### 3. Promise
**What is your unique value proposition?**

- The promise is the expected outcome of your solution based on your unique insight. It must be tightly coupled with the pain point.
- **Sample Questions:**
  - Where is your solution 10x better than existing alternatives?
  - How do users' expectations change before and after using your product?

### 4. Product
**Can your solution deliver on the promise?**

- The final deliverable must be able to effectively solve the Problem faced by the Persona and fulfill the Promise.
- **Sample Questions:**
  - What is the core "Aha Moment" during user onboarding?
  - Which core product features directly correspond to user pain points?

## Usage Scenarios

- **Stuck in neutral:** When the team feels like they're treading water and unable to gain more traction.
- **Direction selection:** When filtering among multiple possible market opportunities or feature paths.
- **Feedback diagnosis:** When user feedback is lukewarm and you need to analyze whether you targeted the wrong Persona or solved the wrong Problem.
