# Priority Chaos

## Definition
Priority chaos refers to founders trying to solve all problems simultaneously, pursuing a "big and comprehensive" product, while ignoring the most core life-or-death issues at the current stage. This thinking pattern leads to scattered resources and slow progress.

## Detection Signals
- **Parallel priorities:** The to-do list has 10 "highest priority" tasks covering everything from low-level architecture optimization to social media avatar updates.
- **Feature stacking:** Rushing to discuss points systems, recommendation algorithms, or multi-language support before the product's core value is proven.
- **Noise sensitivity:** Immediately changing the entire development plan based on occasional feedback from non-core users.
- **Keywords:** "These are all important," "we must be comprehensive," "competitors have it so we must have it too."

## Intervention (Socratic Questioning)
The core of intervention is forcing founders to make brutal trade-offs and identify the true "key leverage point."

- "If your development resources were now reduced to 20% and you could only keep one feature, which would you keep?"
- "If we solve this 'important' feature now but core conversion rates still don't change, will we go out of business?"
- "Among all to-do items, which one—when completed—will make all other tasks easier or unnecessary?"
- "Is what we're doing now building core moats or polishing non-core details?"

## Sample Dialogue

> **Founder:** Next month we're launching V2. Besides optimizing performance by 30%, I also need to refactor the sharing feature, plus add membership systems and dark mode support—these are all critical for user experience.
>
> **Coach:** Sounds like an ambitious plan. I want to confirm: based on last week's data, what is currently the main bottleneck limiting user growth?
>
> **Founder:** It's registration conversion rate. Although plenty of people come in, the percentage who complete registration and create their first project is very low.
>
> **Coach:** Given that, among the performance, refactoring, membership, and dark mode you just mentioned, which action can directly double the number of people who register and create projects?
>
> **Founder:** ...None of them seem to have a direct relationship. I understand, I should focus my energy on simplifying the registration process.
