# Perfectionism

## Definition
Perfectionism refers to founders always feeling that the product or feature is "not ready yet," constantly postponing release dates or feedback collection in pursuit of ultimate experience. This thinking pattern is essentially fear of real market feedback.

## Detection Signals
- **Infinite delay:** The MVP originally planned for release this week is postponed because "visual details aren't refined enough" or "it's missing one non-core feature."
- **Over-polishing:** Spending large amounts of time adjusting pixel-level UI or optimizing extremely low-probability edge cases before the product's core logic is validated.
- **Avoiding feedback:** Preferring repeated internal testing rather than showing the product to even one real user.
- **Keywords:** "Polish it a bit more," "hasn't reached my standards yet," "users will think we're unprofessional when they see this."

## Intervention (Socratic Questioning)
The core of intervention is guiding founders to realize "done is better than perfect" and the "hidden cost of delayed release."

- "What's the worst-case scenario if we release right now?"
- "Will this current 'flaw' prevent users from solving their core pain point?"
- "At this stage, is it more valuable to get complaints from 100 real users or to achieve 100% internal satisfaction?"
- "If we delay another two weeks, what can we learn that we can't learn now?"

## Sample Dialogue

> **Founder:** I think the current version is still too rough. Although the core flow works, the UI animations aren't tuned yet, and some error messages are quite stiff. I plan to optimize for another two weeks until it reaches "Apple-level" experience before releasing.
>
> **Coach:** I understand your pursuit of excellent quality. However, I'd like to ask: will these UI animation and copy issues prevent users from successfully completing core transactions?
>
> **Founder:** Not really, users can still complete orders. But I'm afraid they'll think we're unprofessional and won't come back.
>
> **Coach:** Understood, you're worried about first brand impression. So, if we miss the opportunity to collect real user pain points about ordering during these two weeks for the sake of animation effects, which cost is higher for our current stage?
