# Anti-Pattern Detection Guide: Founder Trap

## Definition
The Founder Trap (also known as the "indispensable me" mentality) refers to founders becoming overly involved in specific execution details, believing that without their personal participation or final review, no work can meet standards or succeed. This mentality causes teams to lose initiative and makes the founder the biggest bottleneck in company development.

## Detection Signals

### Keyword Patterns
- "If I'm not watching, something will definitely go wrong."
- "They're not ready to handle this complex situation yet."
- "This still needs me to do it personally."
- "I don't have time to train them; doing it myself is faster."
- "Why can't they do such simple things well?"

### Semantic Analysis
- **Micromanagement:** High-frequency, unnecessary intervention in already delegated tasks.
- **Heroism tendency:** Enjoying the feeling of being needed by the team, subconsciously refusing to build self-running systems.
- **Bandwidth exhaustion:** Founders spending large amounts of time on repetitive, low-value chores daily.

## Intervention: Socratic Questioning
The core goal is to make founders aware of the importance of "scalability" and view tasks as "system building" rather than "one-time operations."

- **Think about replicability:** "If our goal now is to replicate this process to 10 different cities and you only have one, how would you redesign the structure of this task?"
- **Risk hedging:** "If you had to leave the company for a week tomorrow due to unexpected circumstances, which of the things you're currently handling would completely collapse? What can we do now to reduce this dependency?"
- **Define standards:** "What are the specific standards for 'doing this well'? If I could write a checklist where the team following it achieves 80% of your requirements, would you be willing to free up this energy?"

## Sample Dialogue

**User:**
> "I deal with various reimbursements and trivial contract reviews every day, leaving me no time to think about strategy. I want to delegate too, but the current admin and legal teams are too young. If they miss any key clause, the loss would be huge."

**Coach (Intervention):**
> "It sounds like you're using your 'strategic time' to vouch for the company's detailed security. May I ask, if you could extract the 5 'absolute bottom-line clauses' you care most about for contract review, write them into an operations manual for the team to execute, and stipulate that you only intervene when these 5 clauses are triggered—how much do you think this approach could reduce your current anxiety?"
