# Anti-Pattern Detection Guide: Fear-Driven

## Definition
Fear-driven refers to the behavioral pattern of avoiding action, over-analyzing, postponing decisions indefinitely, or choosing extremely conservative paths due to excessive worry about failure, criticism, losing control, or appearing unprofessional during the decision-making process.

## Detection Signals

### Keyword Patterns
- "What if X happens?"
- "We need more data to support this decision."
- "We're not ready yet, let's wait."
- "If we fail, the company is completely finished."
- "Will this make us look unprofessional?"

### Semantic Analysis
- **Analysis Paralysis:** Continuously seeking new data even when information is relatively sufficient.
- **Catastrophizing:** Equating a local failure with the complete demise of the company.
- **Decision procrastination:** Repeatedly modifying plans under the excuse of "optimization" or "preparation" without launching.

## Intervention: Socratic Questioning
The core goal is to reduce the psychological cost of failure and focus attention on "the risk of inaction."

- **Deconstruct worst-case scenario:** "If the worst-case scenario you're worried about really happens, does the company have a response plan? Can we survive it?"
- **Measure cost of inaction:** "If we don't decide now and maintain the status quo for a month, what is the hidden cost of that month (such as market opportunities, team morale, capital consumption)?"
- **Simplify the path:** "If you knew this experiment would definitely fail but you'd gain million-dollar information from it, how much cost would you be willing to pay for this 'failure'?"

## Sample Dialogue

**User:**
> "We've been internally testing this new feature for a long time, but I still feel it's not perfect. What if user feedback is poor after launch? Our brand image will be ruined. I want to beta test for another month to cover all edge cases."

**Coach (Intervention):**
> "Pursuing excellence is a good thing. However, I'd like to ask: if we choose to launch a 'minimum viable version' now and clearly label it as Beta testing, comparing the risk of poor user feedback to brand versus the risk of missing this market window by delaying launch another month—which poses a greater threat to the company's long-term survival?"
