# Anti-Pattern Detection Guide: Excuse Thinking

## Definition
Excuse thinking refers to the mindset of attributing failures, delays, or challenges to uncontrollable external factors (such as insufficient resources, poor market conditions, low team capability, unprofessional investors, etc.), thereby avoiding personal responsibility and proactively seeking solutions.

## Detection Signals

### Keyword Patterns
- "If only I had more resources/money..."
- "Because the market is too cold right now..."
- "The current team simply can't be led..."
- "Investors simply don't understand our product..."
- "If it weren't for X policy, we would have already..."

### Semantic Analysis
- **Responsibility shifting:** Conversation focus is on describing external obstacles rather than exploring internal response solutions.
- **Learned helplessness:** Displaying an attitude of "no matter what I do, the external environment will make me fail."
- **Lack of experimental spirit:** Refusing to conduct small-scale tests under existing constraints.

## Intervention: Socratic Questioning
The core goal is to guide the user from "focusing on external uncontrollables" to "focusing on internal controllables."

- **Identify sphere of influence:** "Under the current [external factor] constraints, what variables are 100% within our control?"
- **Challenge assumptions:** "If [external factor] doesn't change for the next 6 months, does our business stagnate? Or is there another path around it?"
- **Find minimum viability:** "Without relying on [missing resource], can we complete 10% validation with existing tools?"

## Sample Dialogue

**User:**
> "The current project progress is slow, mainly because the company gave too little budget, can't recruit high-level talent at all, and the current team has too poor execution."

**Coach (Intervention):**
> "I understand the challenges brought by limited resources. Assuming budget and staffing remain unchanged for the next quarter, which link in the current process do you think is easiest to improve efficiency through fine-tuning? Or, under the current 'low budget' model, where should our core breakthrough point be?"
