# Comfort Zone Trap

## Definition
The comfort zone trap refers to founders subconsciously avoiding truly difficult, complex, or highly uncertain tasks (such as cold acquisition, face-to-face sales, handling core technical debt) and instead investing in trivial tasks they're good at that provide immediate sense of accomplishment.

## Detection Signals
- **Illusion of busyness:** Working 12 hours a day but spending most time on replying to emails, adjusting internal document styles, or optimizing already stable code.
- **Selective blindness:** Avoiding discussion of the core difficulty that has been dragging down progress, yet obsessing over a tiny interface change in meetings.
- **Over-research:** Using "research" as an excuse to read large amounts of irrelevant articles or books to avoid starting difficult work.
- **Keywords:** "Let me handle these chores first," "I'll tackle that difficult point when I have a solid block of time," "I need more background information."

## Intervention (Socratic Questioning)
The core of intervention is exposing this "tactical diligence, strategic laziness" and redirecting attention to painful but necessary growth points.

- "Among the things you did today, which one made you feel most anxious or scared? Why?"
- "If we could only do one thing today to move the project forward significantly, would you choose handling chores or that difficult point you haven't touched?"
- "Are you feeling secure because you're busy, or are you actually solving the core obstacle blocking our success?"
- "What 'justification' did you create for yourself to avoid calling those three key customers?"

## Sample Dialogue

> **Founder:** Today I rewrote all the API documentation and organized the team's Wiki directory. I think everyone's information sync efficiency will improve a lot now.
>
> **Coach:** Organizing documents can indeed improve internal efficiency. However, I remember our goal this week was to acquire the first 10 paying seed users. Have you tried contacting any potential customers today?
>
> **Founder:** Not yet, I keep feeling that if our documentation isn't clear, it would be awkward if we can't explain things clearly when customers ask.
>
> **Coach:** Do you think customers care more about whether our Wiki directory is tidy or whether our product can solve their problems?
>
> **Founder:** Of course solving the problem... Alright, I admit, compared to calling strangers and getting rejected, writing documentation does make me feel more comfortable.
