---
name: foto-webcam
description: Liste und Snapshot-Abruf von Webcams (insb. foto-webcam.eu). Verwende diese Skill-Anleitung, wenn John „webcam <nummer>“ schreibt, eine Webcam-Favoritenliste pflegen will, oder wenn ein aktuelles Snapshot-Bild von einer foto-webcam.eu Webcam als JPG im Chat gesendet werden soll.
---

# Foto-Webcam Snapshots

Ziel: Aus einer gespeicherten Favoritenliste (Nummer -> Webcam-Seite) ein aktuelles Bild holen und an John schicken.

## Datenquelle (Favoriten)

Standard-Datei im Workspace:
- `docs/webcams/favorites-muenchen.json`

Format (Beispiel):
- `items[].id` (int)
- `items[].name` (string)
- `items[].page` (URL zur Webcam-Seite)
- optional `items[].image` (direkte Bild-URL)

## Typische Nutzerbefehle

- webcam 1
- webcam 3+4+5
- liste
- liste webcams
- fuege <name> <url> hinzu

## Workflow: webcam N -> Bild senden

1) Lade Favoritenliste aus docs/webcams/favorites-muenchen.json.
2) Suche Eintrag mit id gleich N.
3) Erzeuge Snapshot Bild
   - Wenn image gesetzt ist lade diese Bild URL
   - Sonst page URL nehmen und daraus current 1200 jpg ermitteln
4) Speichere Bild nach /tmp/webcam N jpg
5) Sende Bild im Chat als Attachment
   Caption Format
   Webcam N Name

## Workflow: webcam 3+4+5 -> mehrere Bilder

1) Parse die IDs als Liste von Integers in der Reihenfolge
2) Fuer jede ID
   - Snapshot holen
   - Ein Bild senden
3) Maximal 6 Bilder pro Anfrage, wenn mehr gefragt wird erst nachfragen

## Workflow: liste -> Favoritenliste schicken

Sende eine Text Liste
Webcam 1 Name
Webcam 2 Name
usw

Keine Formatierung, nur Plain Text

## Ermittlung der Bild-URL (foto-webcam.eu)

Für eine Webcam-Seite wie:
- `https://www.foto-webcam.eu/webcam/zugspitze/`

existiert meist ein direktes „current“ Bild:
- `https://www.foto-webcam.eu/webcam/zugspitze/current/1200.jpg`

Praktisch: HTML mit User-Agent laden und nach einem Link auf `.../current/<digits>.jpg` suchen.

## Script

Nutze das Script:
- `skills/public/foto-webcam/scripts/foto_webcam_snapshot.py`

Beispiele:

- Snapshot über Favoriten-ID:
  - `python3 skills/public/foto-webcam/scripts/foto_webcam_snapshot.py --favorites docs/webcams/favorites-muenchen.json --id 4 --out /tmp/webcam4.jpg`

- Snapshot über URL:
  - `python3 skills/public/foto-webcam/scripts/foto_webcam_snapshot.py --url https://www.foto-webcam.eu/webcam/zugspitze/ --out /tmp/zugspitze.jpg`

## Pflege / Ergänzen

- Neue Webcam hinzufügen: ergänze `favorites-muenchen.json` (neue `id`, `name`, `page`).
- Wenn eine Quelle instabil ist, kann `image` gesetzt werden (direkter JPG-Link).

Wichtig: Antworten im Chat nur als Plain Text (kein Markdown). Für Audio nur „clean speech“ (keine Sonderzeichen/Formatierung).
