# Fortune Rules（离线确定性规则）

用于让同样输入尽量得到稳定结果。

## 1) 归一化输入

- 生日：`YYYY-MM-DD`
- 查询日期：`YYYY-MM-DD`
- 问题类型：`overall|wealth|love|career|study|health|social`
- 星盘文本：原样字符串（可包含“命盘十二宫、主星、辅星、庙旺陷、生年禄权科忌”等）

若未提供生日，使用“仅日期规则”，并降低解释细度。

若提供星盘，启用“星盘偏置层”（见第10节）。

## 2) 基础数值

令：

- `B = YYYY + MM + DD`（生日）
- `D = YYYY + MM + DD`（查询日期）
- `R = (B * 131 + D * 17) mod 1000`
- `W = weekday(查询日期)`，周日=0

## 3) 幸运元素映射

### 3.1 方位

索引：`dir_idx = (R + W) mod 8`

方位表：

1. 正北
2. 东北
3. 正东
4. 东南
5. 正南
6. 西南
7. 正西
8. 西北

### 3.2 颜色

主色索引：`c1 = (R div 7) mod 10`
辅色索引：`c2 = (R div 13 + W) mod 10`（与主色重复则+1取模）

颜色表：

- 红
- 橙
- 黄
- 绿
- 青
- 蓝
- 紫
- 白
- 金
- 黑

### 3.3 数字

- `n1 = (R mod 9) + 1`
- `n2 = ((R div 9) mod 9) + 1`
- `n3 = ((R div 81) mod 9) + 1`

去重后取2-3个。

### 3.4 幸运物品

`item_idx = (R + n1 + n2) mod 12`

物品表：

1. 记事本
2. 银色钥匙扣
3. 绿色植物
4. 蓝色水杯
5. 红绳手链
6. 金属书签
7. 薄荷糖
8. 白色手帕
9. 木质小摆件
10. 香囊
11. 护手霜
12. 雨伞

## 4) 运势评分

### 4.1 总分

`S = 40 + (R mod 45) + bonus - penalty`

- `bonus = 8` 当 `W in {1,3,5}`，否则 `3`
- `penalty = 10` 当 `R mod 7 == 0`，否则 `0`
- 最终截断到 `[0,100]`

评级：

- `80-100` 大吉
- `65-79` 中吉
- `45-64` 平
- `0-44` 小凶

### 4.2 分项分

- 财运：`wealth = clamp(S + ((R mod 11) - 5), 0, 100)`
- 桃花：`love = clamp(S + ((R mod 13) - 6), 0, 100)`
- 事业/学业：`career = clamp(S + ((R mod 9) - 4), 0, 100)`
- 人际：`social = clamp(S + ((R mod 7) - 3), 0, 100)`

## 5) 宜忌生成

### 5.1 宜（从下列池按索引取3-5条）

- 先做一件最重要的小任务
- 上午处理沟通事项
- 整理桌面与文件
- 主动表达感谢
- 进行20分钟运动
- 用幸运色配件
- 朝幸运方位出行或就座
- 记一笔今日收支
- 晚上早睡30分钟

### 5.2 忌（取3-5条）

- 冲动消费
- 情绪化回复消息
- 同时开启过多任务
- 熬夜刷短视频
- 与人硬碰硬争辩
- 忽略备份与检查
- 临时做高风险决定
- 拖延关键事项
- 空腹喝咖啡

### 5.3 强禁忌预警（必须输出1-2条）

除普通“忌”外，必须额外生成“强禁忌预警”。每条包含：

- 事项（禁什么）
- 时间窗（从何时到何时）
- 原因（由规则推导）
- 替代动作

可选事项池（按条件触发）：

1. 近期不宜出门远行
2. 近期不宜使用铁器/刀剪
3. 近期不宜夜间独行
4. 近期不宜签高风险承诺

## 6) 解释模板（必须“像样”）

输出详细解释时，按以下逻辑展开：

1. 先讲“命格基调”：由生日 `B` 的奇偶与数位和给出偏稳/偏动。
2. 再讲“日期气场”：由 `D` 与 `W` 判断今日偏沟通、偏执行或偏收敛。
3. 再讲“叠加关系”：为什么形成当前评级。
4. 最后逐项解释“方位/颜色/数字/物品/宜忌”各自对应的行为含义。

## 7) 单项查询补充

### 财运

额外输出：

- 进财时段：
  - `slot = (R mod 3)` -> 上午/下午/晚间
- 破财风险点：从“忌”里挑最相关1-2条
- 增财动作：1条立即可执行
- 守财动作：1条立即可执行

### 桃花运

额外输出：

- 社交利好时段（同slot映射）
- 开场话题建议1条
- 沟通避雷1条

## 8) 次日推送文本格式（精简版）

- 标题：`【明日运势 | YYYY-MM-DD】`
- 四行速览：评级、方位、颜色、数字
- 两段正文：宜做（3条）、忌做（3条）
- 尾句：一句重点提醒

并追加：

- `禁忌预警`：1条（含“到什么时间解除”）

## 9) 一致性原则

同一输入下，核心元素（评级、方位、颜色、数字）应保持一致；
允许措辞变化，但不应频繁改变结论方向。

## 10) 星盘偏置层（紫微斗数文本版）

> 目标：不做复杂天文计算，仅对用户提供的命盘文本做“结构化关键词计分”，并稳定叠加到第4节分数。

### 10.1 宫位抓取

优先抓取：

- 命宫
- 财帛宫
- 官禄宫
- 夫妻宫
- 交友宫
- 迁移宫
- 福德宫

若任一宫缺失，不报错，按可用宫位继续。

### 10.2 星曜状态计分

对上述宫位内的“主星+辅星”进行关键词计分：

- `庙` +3
- `旺` +2
- `得` +1
- `利` +1
- `平` 0
- `陷` -2

宫位状态分记为 `P_house`。

### 10.3 四化计分

在上述宫位内匹配：

- `禄` +2
- `权` +1
- `科` +1
- `忌` -2

宫位四化分记为 `Q_house`。

### 10.4 宫位到分项映射

定义：

- `命宫总分 = P命宫 + Q命宫`
- `财宫总分 = P财帛宫 + Q财帛宫`
- `官宫总分 = P官禄宫 + Q官禄宫`
- `夫宫总分 = P夫妻宫 + Q夫妻宫`
- `友宫总分 = P交友宫 + Q交友宫`
- `迁宫总分 = P迁移宫 + Q迁移宫`
- `福宫总分 = P福德宫 + Q福德宫`

四项偏置：

- `bias_wealth = clamp(round((财宫总分 + 命宫总分*0.4 + 官宫总分*0.3)/4), -12, 12)`
- `bias_love = clamp(round((夫宫总分 + 友宫总分*0.5 + 福宫总分*0.5)/4), -12, 12)`
- `bias_career = clamp(round((官宫总分 + 命宫总分*0.5 + 迁宫总分*0.5)/4), -12, 12)`
- `bias_social = clamp(round((友宫总分 + 迁宫总分*0.6 + 命宫总分*0.4)/4), -12, 12)`

总览偏置：

- `bias_overall = clamp(round((命宫总分 + 福宫总分 + 官宫总分)/6), -10, 10)`

### 10.5 分数叠加

在第4节基础上叠加：

- `S' = clamp(S + bias_overall, 0, 100)`
- `wealth' = clamp(wealth + bias_wealth, 0, 100)`
- `love' = clamp(love + bias_love, 0, 100)`
- `career' = clamp(career + bias_career, 0, 100)`
- `social' = clamp(social + bias_social, 0, 100)`

最终评级由 `S'` 决定。

### 10.6 幸运元素微调（有星盘时）

- 若 `迁移宫总分 >= 3`：方位结果顺时针偏移1格
- 若 `财宫总分 <= -3`：数字中去掉最大值，补入 `((n1+n2) mod 9)+1`
- 若 `福宫总分 >= 3`：颜色优先保留冷色（青/蓝/紫）之一

### 10.7 解释模板补充（有星盘时）

详细解释中必须增加：

1. 命宫人格底色（执行风格/决策方式）
2. 财帛+官禄联动（赚钱方式与职业路径）
3. 夫妻+交友联动（关系模式与沟通雷区）
4. 迁移宫提示（外出、换环境、合作窗口）

并给出至少2条“本日可执行动作”。

## 11) 初次设置记忆规范（持久化）

### 11.1 建档触发

满足任一条件即触发建档：

- 用户明确说“记住我的星盘/保存我的星盘”
- 首次检测到完整命盘文本（含“命盘十二宫”等关键段）

### 11.2 存储位置

默认写入技能目录：

- `{baseDir}/user_chart_profile.json`

### 11.3 JSON建议结构

```json
{
  "profileVersion": "1.0.0",
  "updatedAt": "<YYYY-MM-DDTHH:mm:ss+08:00>",
  "basic": {
    "gender": "<待填写>",
    "clockTime": "<YYYY-MM-DD HH:mm>",
    "trueSolarTime": "<YYYY-MM-DD HH:mm>",
    "lunarTime": "<待填写>",
    "baziJieqi": "<待填写>",
    "baziNonJieqi": "<待填写>",
    "mingZhu": "<待填写>",
    "shenZhu": "<待填写>"
  },
  "chartRaw": "<原始命盘文本>",
  "chartSummary": "<结构化摘要>"
}
```

### 11.4 复用规则

- 后续查询默认读取本地档案，不再要求重复输入星盘。
- 若用户提供新盘：
  - 先提示“检测到新星盘，是否覆盖旧档案？”
  - 用户确认后覆盖。
- 若用户说“重置星盘”：清空上述两个文件内容或标记为失效。

### 11.5 回退策略

- 无法读写文件时：仅在当前会话保留星盘摘要，并提示用户当前环境不支持持久化。

## 12) 禁忌时间窗与原因生成（关键）

> 目标：让“不要做什么”具备可执行的时间边界与解释依据。

### 12.1 风险等级

定义风险分：

- `risk = 100 - S'`（无星盘时用 `S`）

风险等级：

- `risk >= 50`：高风险（输出2条强禁忌）
- `30 <= risk < 50`：中风险（输出1-2条强禁忌）
- `risk < 30`：低风险（输出1条轻量禁忌）

### 12.2 时间窗计算（到什么时候）

令：

- `start = 查询日期 00:00`
- `hours = 12 + (R mod 25)`（范围 12~36 小时）
- `end = start + hours`

输出格式示例：

- `禁忌时间：即刻起至 YYYY-MM-DD HH:mm`

若触发高风险，追加第二时间窗：

- `hours2 = 36 + (R mod 37)`（范围 36~72 小时）
- `end2 = start + hours2`

### 12.3 触发条件（确定性）

1. **不宜出门远行**

- 触发任一条件即启用：
  - `risk >= 50`
  - `迁宫总分 <= -2`（有星盘）
  - `(R + W) mod 6 in {0, 3}`

解释模板：

- `迁移/日期波动偏冲，外部变量增多，远行与临时变更叠加易出纰漏。`

替代动作：

- `改为近距离办事、线上沟通、必要外出避开高峰并预留冗余时间。`

2. **不宜使用铁器/刀剪**

- 触发任一条件即启用：
  - `risk >= 45`
  - `命宫总分 <= -1`（有星盘）
  - `(R mod 8) in {1, 4, 7}`

解释模板：

- `当日气场偏急、注意力易分散，锋利金属类操作容错低，易引发小伤或冲动操作。`

替代动作：

- `改用预切食材/安全剪，涉及刀具工作延后到禁忌窗口后再处理。`

3. **不宜夜间独行**

- 触发条件：`social' <= 45` 或 `(R mod 5 == 0)`

时间窗：当日 `21:00` 至次日 `01:00`

4. **不宜签高风险承诺**

- 触发条件：`career' <= 48` 或 `wealth' <= 48`

时间窗：`即刻起至 end`

### 12.4 输出要求

每条强禁忌必须采用固定四段：

1. `禁忌事项：...`
2. `禁忌时间：...（到什么时候）`
3. `原因：...（命盘/日期规则依据）`
4. `替代方案：...`

禁止只写“不要做X”而不写时间和原因。
