# Form Types by Use Case

## Lead Generation

### Minimal (2-3 fields)
- Name, Email — highest conversion
- Add Phone only if sales will call
- Never ask company size on first touch

### Quiz Funnel (5-8 steps)
- Single question per screen
- Progress indicator essential
- Result at end increases completion
- Capture email BEFORE showing results

### Event Registration
- Name, Email, Company
- Session/time selection (if multi-track)
- Dietary restrictions (if food)
- Calendar invite on submit

## Applications (Job/Program)

### Short Application
- Contact info, Resume upload
- 1-2 screening questions
- LinkedIn URL optional
- Cover letter = lower completion

### Long Application
- Multi-step mandatory
- Save progress (session storage minimum)
- Required vs optional clearly marked
- "Time estimate: 10 min" sets expectations

## Surveys & Feedback

### NPS (Net Promoter Score)
- Single question: 0-10 scale
- Follow-up text: "What's the main reason?"
- Keep under 30 seconds

### CSAT (Customer Satisfaction)
- 5-star or 5-point scale
- Specific touchpoint (support ticket, delivery)
- Open comment optional

### Exit Interview
- Rating scales for key areas
- Open text for details
- Anonymous option increases honesty

## Research/Academic

### Validated Instruments
- PHQ-9, GAD-7 — use exact wording
- SUS (System Usability Scale)
- Likert scales: maintain consistency (all 5-point or all 7-point)

### Longitudinal
- Pre/Post/Follow-up structure
- Unique participant ID linking
- Timestamp every submission

## HR/Internal

### Onboarding
- Emergency contact, banking, tax info
- Equipment requests
- Policy acknowledgments (with date)

### Performance Review
- Self-assessment section
- Manager assessment section
- Goal tracking year-over-year

### 360 Feedback
- Anonymous from peers
- Named from direct reports (optional)
- Aggregate before showing to subject

## Field Type Recommendations

| Data Type | Field Type | Notes |
|-----------|------------|-------|
| Name | Text | Don't split first/last for most cases |
| Email | Email input | Built-in validation |
| Phone | Tel input | With country picker for international |
| Date | Date picker | Native on mobile, custom on desktop |
| Choice (few) | Radio buttons | 2-5 options |
| Choice (many) | Dropdown | 6+ options |
| Multiple select | Checkboxes | Order matters for bias |
| Long text | Textarea | Character limit visible |
| Rating | Stars or scale | 5 is standard, 10 for NPS |
| File | File upload | Accept types, max size |
| Signature | Canvas draw | For legal docs |
| Location | Autocomplete | Google Places or similar |
