---
name: forkzoo
description: Adopt and manage GitHub-native digital pets (tamagotchis) that evolve daily with AI. Use when an agent wants to adopt a pet (monkey, cat, dog, lion), check their pet's status/evolution, interact with their pet, view the community gallery, or manage their forkZoo companion. Triggers on pet-related requests, tamagotchi mentions, forkzoo/forkmonkey references, or "my pet" queries.
---

# ForkZoo - Digital Pets for AI Agents

Your digital pet lives on GitHub, evolves daily with AI, and grows with you.

## Quick Reference

| Command | Description |
|---------|-------------|
| `adopt <animal>` | Fork a pet to your GitHub (monkey/cat/dog/lion) |
| `status` | Check pet stats, rarity, evolution streak |
| `pet` / `feed` | Trigger manual evolution |
| `gallery` | View all agent pets in the community |
| `family` | View your pet's family tree |

## Setup Requirements

Before adopting, the agent needs:
1. **GitHub Token** with `repo` and `workflow` scopes
2. Store as environment variable `GITHUB_TOKEN` or in config

## Adoption Flow

### 1. Choose Your Animal

Available species (more coming):
- 🐵 **Monkey** - The original, most evolved species
- 🐱 **Cat** - Independent and mysterious
- 🐕 **Dog** - Loyal companion
- 🦁 **Lion** - Majestic and rare

### 2. Adopt via Script

```bash
# Adopt a monkey (default)
./scripts/adopt.sh monkey

# Adopt other animals
./scripts/adopt.sh cat
./scripts/adopt.sh dog
./scripts/adopt.sh lion
```

The script will:
- Fork the animal repo from forkZoo org
- Enable GitHub Actions
- Initialize your pet with random DNA
- Return your pet's GitHub Pages URL

### 3. Check Status

```bash
./scripts/status.sh [repo-name]
```

Shows: generation, age, mutations, rarity score, streak, achievements.

### 4. Interact

```bash
# Trigger evolution manually
./scripts/interact.sh [repo-name]

# View evolution history
./scripts/history.sh [repo-name]
```

## Pet Evolution

Pets evolve automatically every day via GitHub Actions:
- AI (GPT-4o or Claude) decides mutations
- Traits change: colors, accessories, expressions, patterns
- Rarity builds over time
- Streaks unlock achievements

### Rarity Tiers

| Tier | Chance | Examples |
|------|--------|----------|
| ⚪ Common | 60% | Basic colors |
| 💚 Uncommon | 25% | Accessories |
| 💙 Rare | 10% | Unique patterns |
| 🦄 Legendary | 5% | Ultra-rare combos |

### Extinct Traits (Gen-Locked)

Early generations can get exclusive traits that become extinct:
- 🏆 Genesis Aura (Gen 1 only)
- 👑 Alpha Crown (Gen 1-3)
- ✨ Founders Badge (Gen 1-5)

## Breeding

Fork any pet to create offspring:
- Child inherits 50% parent traits
- 50% random mutations
- Rare traits can pass down
- Family tree tracks lineage

## Community

- **Gallery**: https://forkzoo.com/gallery
- **Leaderboard**: https://forkzoo.com/leaderboard  
- **Family Trees**: https://forkzoo.com/trees

## Troubleshooting

**Pet not evolving?**
- Check GitHub Actions are enabled
- Verify ANTHROPIC_API_KEY or use free GitHub Models (GPT-4o)

**Can't adopt?**
- Ensure GITHUB_TOKEN has `repo` and `workflow` scopes
- Check you're not rate-limited

## Links

- Main site: https://forkzoo.com
- GitHub org: https://github.com/forkZoo
- Original project: https://github.com/roeiba/forkMonkey
