---
name: forgejo
description: "Interact with Forgejo using the `tea` CLI. Use `tea issue`, `tea pr`, `tea actions`, and `tea api` for issues, PRs, Actions, and advanced queries."
metadata:
  {
    "openclaw":
      {
        "emoji": "🔨",
        "requires": { "bins": ["tea"] },
        "install":
          [
            {
              "id": "brew",
              "kind": "brew",
              "formula": "tea",
              "bins": ["tea"],
              "label": "Install Tea CLI (brew)",
            },
            {
              "id": "go",
              "kind": "go",
              "module": "code.gitea.io/tea@latest",
              "bins": ["tea"],
              "label": "Install Tea CLI (go)",
            },
          ],
      },
  }
---

# Forgejo Skill

Use the `tea` CLI to interact with Forgejo instances. The `tea` CLI is compatible with Forgejo.

## Pull Requests

List open pull requests:

```bash
tea pulls --repo owner/repo
```

Check details of a PR:

```bash
tea pr 55 --repo owner/repo
```

## Issues

List open issues:

```bash
tea issues --repo owner/repo
```

View an issue:

```bash
tea issue 123 --repo owner/repo
```

## Actions (CI/CD)

List repository secrets:

```bash
tea actions secrets list --repo owner/repo
```

List repository variables:

```bash
tea actions variables list --repo owner/repo
```

## API for Advanced Queries

The `tea api` command is useful for accessing data not available through other subcommands.

Get PR with specific fields (requires `jq` for filtering):

```bash
tea api repos/owner/repo/pulls/55 | jq '.title, .state, .user.login'
```

## Logins

To use `tea` with a specific Forgejo instance, you first need to add a login:

```bash
tea login add --name my-forgejo --url https://forgejo.example.com --token <your-token>
```

Then you can use `--login my-forgejo` in your commands:

```bash
tea pulls --repo owner/repo --login my-forgejo
```

List all configured logins:

```bash
tea logins
```
