# 🔄 Forge 维修-监理自动循环协议

## 流程

```
任务进入
  │
  ▼
┌──────────────────────────────┐
│  派维修工程师 (spawn)         │
│  输入: 任务 + 上轮issues     │
└──────────┬───────────────────┘
           ▼
┌──────────────────────────────┐
│  检查维修报告                 │
│  全BLOCKED → NEEDS_HUMAN     │
│  有FIXED → 继续监理           │
└──────────┬───────────────────┘
           ▼
┌──────────────────────────────┐
│  派监理 (spawn)               │
│  输入: 验收标准 + 维修报告    │
└──────────┬───────────────────┘
           ▼
┌──────────────────────────────┐
│  判定                        │
│  PASS → commit + 通知 ✅      │
│  FAIL → 回到维修（自动）      │
│  NEEDS_HUMAN → 暂停           │
│  >5轮 → 升级给人              │
└──────────────────────────────┘
```

## 触发条件

自动启动此循环：
1. Code review / audit findings that need fixing
2. Automated monitoring detects high severity issues
3. User says "fix X" / "resolve X"

## 行为承诺

1. **FAIL/CONDITIONAL → 自动循环**，不问人
2. **PASS → 自动commit**，然后通知
3. **NEEDS_HUMAN → 暂停**，把问题发给人
4. **超5轮 → 升级**，承认能力不足

## 安全护栏（三层）

| 层 | 作用 | 机制 |
|----|------|------|
| 第一层 | 定义 | `protected-files.txt` 列出禁碰文件 |
| 第二层 | 检测 | commit前diff审查（删除/保护/规模） |
| 第三层 | 预防 | 维修工程师prompt约束 |

## 不适用场景

- Prompt修改（需人审阅）
- 架构决策（需人拍板）
- <10分钟简单修复（直接改）
- 涉及受保护文件（需授权）

## 成本参考

- 每轮: 维修(~30K tokens) + 监理(~15K tokens) ≈ $2.7
- 5轮上限 ≈ $13.5（一般2-3轮收敛）
