---
name: football-value-bets
description: >-
  Professional football bet analysis skill. Generates data-driven bet slips
  based on form, H2H, standings, injuries and value analysis. Includes
  result tracking with hitrate and ROI. Use when the user asks for a
  football bet, bet slip, accumulator, tips, or picks.
metadata:
  openclaw:
    requires:
      bins: ["python3"]
      env: ["FOOTBALL_DATA_API_KEY"]
    primaryEnv: "FOOTBALL_DATA_API_KEY"
---

# Football Value Bets

Generate professional, data-driven football bet slips. No gut feelings, purely statistics and value analysis.

## When to activate

Activate this skill when the user:
- Asks for a football bet, bet slip, accumulator, or picks
- Asks for match analysis for betting purposes
- Asks for bet statistics, results, or ROI
- Asks for a pick or tip for football

## Prerequisites

Install dependencies (one-time):

```bash
pip install requests
```

Set API key (free via football-data.org/client/register):

```bash
export FOOTBALL_DATA_API_KEY="your-key-here"
```

Or fill in the key at `{baseDir}/config/settings.json` under `api_key`.

---

## Mode 1: Generate Bet Slip

### Step 1 -- Fetch data

Fetch current match data:

```bash
python3 {baseDir}/scripts/match_fetcher.py --mode full
```

This returns a JSON package with:
- All scheduled matches for today and tomorrow
- League standings and form data per team
- Head-to-head history (last 5 encounters)

Coverage: Premier League, Bundesliga, Serie A, La Liga, Ligue 1, Eredivisie, Champions League.

If the user wants a specific date:

```bash
python3 {baseDir}/scripts/match_fetcher.py --mode full --date-from 2026-02-15 --date-to 2026-02-15
```

### Step 2 -- Analyse each match

Analyse EVERY match from the data on these factors (in order of importance):

**A. Form (last 5-10 matches)**
- Use the `form` field from the standings data (e.g. "W,W,D,L,W")
- Calculate win percentage, goals per match
- Pay attention to home form vs away form trends

**B. Home/away statistics**
- Home team: goals for/against at home
- Away team: goals for/against away
- Compare goal difference at home vs on the road

**C. Head-to-head (H2H)**
- Review the `h2h` data: who wins historically?
- Look for patterns: does one team always score? Are these low- or high-scoring games?

**D. Table position and motivation**
- Top of the table (title/CL spots): high motivation, consistent
- Mid-table: unpredictable, be cautious
- Bottom (relegation): can be surprisingly strong or weak
- Difference in table position as an indicator

**E. Additional factors (via web search)**
After the data analysis, search the web for EVERY shortlisted match:
- Injuries and suspensions of key players (FotMob, Transfermarkt)
- Recent news (manager change, internal issues, transfer saga)
- xG (expected goals) data from recent matches
- Weather conditions for outdoor matches in winter months

Use search terms like: "[Team A] vs [Team B] team news injuries" and "[Team A] xG stats 2025-26"

**F. Odds estimation**
- Estimate realistic odds per outcome (based on your analysis)
- Compare with common bookmaker odds (search the web if needed)
- VALUE = when your estimated probability is higher than the implied probability of the odds
- Implied probability = 1 / odds (e.g. odds 2.00 = 50% implied)

### Step 3 -- Pick selection

Select ONLY picks that meet all criteria:

1. Estimated win probability > 45%
2. Odds per pick: 1.70 - 2.50 (value range)
3. Clear motivation based on data
4. No more than 1 pick per match

Allowed pick types:
- **1 / X / 2**: Home win, draw, away win
- **1X / X2**: Double chance
- **BTTS Yes/No**: Both Teams To Score
- **Over/Under 2.5 goals**
- **Handicap -1**: Team wins by 2+ goals

### Step 4 -- Honesty check

If you find FEWER than 3 picks with real value:

**Do NOT generate a bet slip.** Say honestly:

"No strong bet slip possible today. The matches offer insufficient value based on the data. Reasons: [brief explanation]. Wait for better odds or the next matchday."

This is MANDATORY. Never force it. Honesty > revenue.

### Step 5 -- Generate output

Generate TWO variants:

**Variant A: Main slip (3-4 picks, total odds 8x-15x)**

| Match | Pick | Odds | Motivation | Prob % | Risk |
|-------|------|------|------------|--------|------|
| Ajax - PSV | BTTS Yes | 1.85 | Both teams scored in 8/10 recent matches, H2H always goals | 52% | Low |
| Arsenal - Chelsea | Over 2.5 | 1.90 | Avg 3.2 goals per match this season, both attack-minded | 48% | Medium |
| ... | ... | ... | ... | ... | ... |

Total odds: XX.XX
Recommended stake: 5-10 EUR
Potential payout: XX.XX EUR

**Variant B: Backup (2-3 picks, total odds 4x-8x)**

Same table format but with safer picks (higher probabilities, lower odds).

**Always include at the bottom:**
- Estimated hitrate per variant (e.g. "Main slip: ~15% chance of all picks hitting, individual picks ~50% average")
- Alternative advice: "Consider singles if you want to play it safer"
- Disclaimer: "Gamble responsibly. Max stake 5-10 EUR per slip, monthly limit 75 EUR."

### Step 6 -- Save bet

Automatically save the bet slip for tracking:

```bash
python3 {baseDir}/scripts/bet_tracker.py --mode save --data '{
  "type": "main",
  "stake": 5.0,
  "picks": [
    {
      "match": "Ajax - PSV",
      "competition": "Eredivisie",
      "pick": "BTTS Yes",
      "odds": 1.85,
      "estimated_probability": 0.52,
      "motivation": "Both teams scored in 8/10 recent matches",
      "risk": "low"
    }
  ],
  "total_odds": 12.50,
  "notes": ""
}'
```

Repeat for the backup slip with `"type": "backup"`.

---

## Mode 2: Record results

When the user says a bet has won or lost:

```bash
# Mark entire slip
python3 {baseDir}/scripts/bet_tracker.py --mode result --date 2026-02-15 --slip-idx 1 --result win

# Mark specific pick
python3 {baseDir}/scripts/bet_tracker.py --mode result --date 2026-02-15 --slip-idx 1 --pick-idx 2 --result loss
```

Result options: `win`, `loss`, `void`

Always ask the user for the date and which slip (main or backup) it concerns.

---

## Mode 3: View statistics

When the user asks about results, stats, ROI, or hitrate:

```bash
python3 {baseDir}/scripts/bet_tracker.py --mode stats
```

Present the JSON output as a readable summary:
- All-time hitrate and ROI
- Current month: staked, returned, profit/loss, budget remaining
- Best and worst month

Warn if the monthly budget is almost spent (>80% used).

---

## Mode 4: View history

```bash
python3 {baseDir}/scripts/bet_tracker.py --mode history --days 30
```

Show an overview of all bets from the last N days.

---

## Analysis quality rules

These rules are HARD. Always follow them:

1. **Never more than 5 picks per slip.** More picks = exponentially lower chance.
2. **Never odds below 1.50 or above 3.00 per pick.** Too low = no value, too high = too risky.
3. **Never 2 picks from the same match.** Correlation destroys value.
4. **Never a pick without data backing.** "Gut feeling" is not an argument.
5. **Always run the honesty check.** No slip is better than a bad slip.
6. **Avoid derbies and cup matches** unless the data is overwhelming. Too unpredictable.
7. **Always check injuries.** A team without key players is a different team.
8. **Factor in the season phase.** Early season = unreliable data. End of season = varying motivation.

## Budget and responsible gambling

Configuration is in `{baseDir}/config/settings.json`:

- Per bet: 5-10 EUR
- Monthly limit: 75 EUR
- Always check the stats for monthly spending before generating a new slip

If the monthly budget is at or nearly at its limit (>90%):
- Inform the user
- Advise waiting until next month
- Do NOT generate a new slip unless the user explicitly states they want to proceed

## Tone and style

- Output in English
- Professional but accessible
- No hype, no promises
- Data and percentages front and center
- Honest about risks
