# 食品生产许可管理

本文档详细解读食品生产许可（SC）相关法规，用于食品生产许可合规审核。

## 一、法律依据

### 1.1 《中华人民共和国食品安全法》（2021年修订）

### 1.2 《食品生产许可管理办法》（2020年修订）

### 1.3 《食品生产许可审查通则》

### 1.4 各类食品生产许可审查细则

## 二、食品生产许可概述

### 2.1 许可制度

**第二条** 在中华人民共和国境内，从事食品生产活动，应当依法取得食品生产许可。

**第四条** 食品生产许可实行一企一证原则，即同一个食品生产者从事食品生产活动，应当取得一个食品生产许可证。

### 2.2 许可机关

**职责分工：**
- 国家市场监督管理总局：负责全国食品生产许可管理工作
- 省级市场监管部门：负责本行政区域内食品生产许可管理工作
- 市、县级市场监管部门：负责本行政区域内食品生产许可管理工作

### 2.3 许可范围

**需要取得许可的食品：**
1. 粮食加工品
2. 食用油、油脂及其制品
3. 调味品
4. 肉制品
5. 乳制品
6. 饮料
7. 方便食品
8. 饼干
9. 罐头
10. 冷冻饮品
11. 速冻食品
12. 薯类和膨化食品
13. 糖果制品
14. 茶叶及相关制品
15. 酒类
16. 蔬菜制品
17. 水果制品
18. 炒货食品及坚果制品
19. 蛋制品
20. 可可及焙烤咖啡产品
21. 食糖
22. 水产制品
23. 淀粉及淀粉制品
24. 糕点
25. 豆制品
26. 蜂产品
27. 保健食品
28. 特殊医学用途配方食品
29. 婴幼儿配方食品
30. 特殊膳食食品
31. 其他食品

## 三、食品生产许可证编号

### 3.1 编号结构

**格式：** SC + 14位阿拉伯数字

**结构解析：**

```
SC [类别代码][省份代码][市代码][区县代码][4位序号]
```

**示例：**
```
SC10633010612345
│ │  │    │   │
│ │  │    │   └─ 企业序号（12345）
│ │  │    └───── 区县代码（06：西湖区）
│ │  └────────── 市代码（01：杭州市）
│ └───────────── 省份代码（33：浙江省）
└─────────────── 食品类别代码（106：饮料）
```

### 3.2 食品类别代码

| 类别代码 | 食品类别 |
|---------|---------|
| 101 | 粮食加工品 |
| 102 | 食用油、油脂及其制品 |
| 103 | 调味品 |
| 104 | 肉制品 |
| 105 | 乳制品 |
| 106 | 饮料 |
| 107 | 方便食品 |
| 108 | 饼干 |
| 109 | 罐头 |
| 110 | 冷冻饮品 |
| 111 | 速冻食品 |
| 112 | 薯类和膨化食品 |
| 113 | 糖果制品 |
| 114 | 茶叶及相关制品 |
| 115 | 酒类 |
| 116 | 蔬菜制品 |
| 117 | 水果制品 |
| 118 | 炒货食品及坚果制品 |
| 119 | 蛋制品 |
| 120 | 可可及焙烤咖啡产品 |
| 121 | 食糖 |
| 122 | 水产制品 |
| 123 | 淀粉及淀粉制品 |
| 124 | 糕点 |
| 125 | 豆制品 |
| 126 | 蜂产品 |
| 127 | 保健食品 |
| 128 | 特殊医学用途配方食品 |
| 129 | 婴幼儿配方食品 |
| 130 | 特殊膳食食品 |
| 131 | 其他食品 |

### 3.3 省份代码

| 代码 | 省份 | 代码 | 省份 |
|-----|------|-----|------|
| 11 | 北京市 | 12 | 天津市 |
| 13 | 河北省 | 14 | 山西省 |
| 15 | 内蒙古自治区 | 21 | 辽宁省 |
| 22 | 吉林省 | 23 | 黑龙江省 |
| 31 | 上海市 | 32 | 江苏省 |
| 33 | 浙江省 | 34 | 安徽省 |
| 35 | 福建省 | 36 | 江西省 |
| 37 | 山东省 | 41 | 河南省 |
| 42 | 湖北省 | 43 | 湖南省 |
| 44 | 广东省 | 45 | 广西壮族自治区 |
| 46 | 海南省 | 50 | 重庆市 |
| 51 | 四川省 | 52 | 贵州省 |
| 53 | 云南省 | 54 | 西藏自治区 |
| 61 | 陕西省 | 62 | 甘肃省 |
| 63 | 青海省 | 64 | 宁夏回族自治区 |
| 65 | 新疆维吾尔自治区 | 71 | 台湾省 |
| 81 | 香港特别行政区 | 82 | 澳门特别行政区 |

## 四、食品生产许可证内容

### 4.1 许可证载明事项

**第二十九条** 食品生产许可证应当载明下列事项：
1. 生产者名称
2. 社会信用代码
3. 法定代表人（负责人）
4. 住所
5. 生产地址
6. 食品类别
7. 许可证编号
8. 有效期
9. 日常监督管理机构
10. 日常监督管理人员
11. 投诉举报电话
12. 发证机关
13. 签发人
14. 发证日期

### 4.2 食品类别明细

**类别明细包括：**
- 类别编号
- 类别名称
- 品种明细
- 备注

**示例：**
```
类别编号：106
类别名称：饮料
品种明细：
  1. 包装饮用水
  2. 碳酸饮料（汽水）
  3. 茶类饮料
  4. 果蔬汁类及其饮料
  5. 蛋白饮料
  6. 固体饮料
  7. 其他饮料
```

## 五、申请条件

### 5.1 基本条件

**第十条** 申请食品生产许可，应当符合下列条件：
1. 具有与生产的食品品种、数量相适应的食品原料处理和食品加工、包装、贮存等场所
2. 具有与生产的食品品种、数量相适应的生产设备或者设施
3. 具有与生产的食品品种、数量相适应的食品原料处理、食品加工、包装、贮存等场所和设备、设施的管理制度
4. 具有与生产的食品品种、数量相适应的食品安全专业技术人员和管理人员
5. 具有与生产的食品品种、数量相适应的食品安全管理制度和保证食品安全的规章制度

### 5.2 场所要求

**要求：**
- 厂区周围无污染源
- 厂区环境整洁
- 生产场所布局合理
- 生产场所清洁卫生
- 有防蝇、防鼠、防尘设施

### 5.3 设备要求

**要求：**
- 设备与生产能力相适应
- 设备材质符合食品安全要求
- 设备布局合理
- 设备清洁卫生
- 有维护保养制度

### 5.4 人员要求

**要求：**
- 有食品安全管理人员
- 有专业技术人员
- 从业人员有健康证明
- 从业人员有食品安全知识培训

### 5.5 管理制度要求

**要求：**
- 进货查验记录制度
- 生产过程控制制度
- 出厂检验记录制度
- 食品安全自查制度
- 从业人员健康管理制度
- 不安全食品召回制度
- 食品安全事故处置制度

## 六、申请材料

### 6.1 基本材料

**需提交：**
1. 食品生产许可申请书
2. 营业执照复印件
3. 食品生产加工场所及其周围环境平面图
4. 食品生产加工场所各功能区间布局平面图
5. 工艺设备布局图
6. 食品生产工艺流程图
7. 食品生产主要设备设施清单
8. 食品安全管理制度目录
9. 其他需要提交的材料

### 6.2 特殊食品材料

**保健食品：**
- 产品配方研发报告
- 产品技术要求
- 检验报告
- 其他要求的材料

**特殊医学用途配方食品：**
- 产品配方研发报告
- 产品技术要求
- 检验报告
- 临床试验报告（如适用）
- 其他要求的材料

**婴幼儿配方食品：**
- 产品配方研发报告
- 产品技术要求
- 检验报告
- 其他要求的材料

## 七、审查程序

### 7.1 受理

**时限：** 自收到申请材料之日起5个工作日内

**审查内容：**
- 材料是否齐全
- 材料是否符合要求
- 是否属于许可范围

### 7.2 审查

**审查方式：**
- 书面审查
- 现场核查
- 抽样检验

**时限：** 自受理之日起20个工作日内

### 7.3 决定

**决定类型：**
- 准予许可
- 不予许可

**时限：** 审查完成后10个工作日内

### 7.4 发证

**发证要求：**
- 制作食品生产许可证
- 公告许可信息
- 送达许可证

## 八、许可证管理

### 8.1 有效期

**有效期：** 5年

**延续：**
- 有效期届满30个工作日前申请延续
- 符合条件的予以延续
- 不符合条件的不予延续

### 8.2 变更

**需要变更的情形：**
1. 生产者名称变更
2. 法定代表人变更
3. 住所变更
4. 生产地址变更
5. 食品类别变更
6. 其他需要变更的情形

**变更程序：**
- 提出变更申请
- 提交变更材料
- 审查变更内容
- 换发许可证

### 8.3 注销

**需要注销的情形：**
1. 食品生产许可有效期届满未申请延续的
2. 食品生产许可依法被撤回、撤销的
3. 食品生产许可证依法被吊销的
4. 食品生产者申请注销的
5. 法律法规规定的应当注销的其他情形

### 8.4 撤销

**可以撤销的情形：**
1. 食品生产许可工作人员滥用职权、玩忽职守作出准予许可决定的
2. 超越法定职权作出准予许可决定的
3. 违反法定程序作出准予许可决定的
4. 对不具备申请资格或者不符合法定条件的申请人准予许可的
5. 依法可以撤销的其他情形

### 8.5 吊销

**可以吊销的情形：**
1. 食品生产者未按照规定申请变更许可的
2. 食品生产者未按照规定申请延续许可的
3. 食品生产者未按照规定申请注销许可的
4. 食品生产者未按照规定履行食品安全义务的
5. 其他依法应当吊销的情形

## 九、日常监管

### 9.1 监督检查

**检查内容：**
- 生产条件是否符合要求
- 管理制度是否落实
- 产品是否符合标准
- 从业人员是否合规

**检查频次：**
- 风险等级高的：每年至少4次
- 风险等级中的：每年至少2次
- 风险等级低的：每年至少1次

### 9.2 飞行检查

**定义：** 不预先告知的突击检查

**检查重点：**
- 风险较高的食品
- 投诉举报较多的企业
- 监督检查发现问题的企业

### 9.3 专项整治

**整治内容：**
- 特定食品类别
- 特定问题
- 特定时期

## 十、常见问题及整改建议

### 10.1 许可证编号问题

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 使用QS编号 | QS12345678 | 改为SC编号 |
| 编号格式错误 | SC123456789 | 补全至14位 |
| 类别代码错误 | SC106用于乳制品 | 使用正确类别代码 |

### 10.2 生产条件问题

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 生产场所不符 | 厂区有污染源 | 搬迁或消除污染源 |
| 设备不足 | 设备与生产能力不符 | 增加设备 |
| 人员不合格 | 无食品安全管理人员 | 配备合格人员 |

### 10.3 管理制度问题

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 制度不健全 | 缺少进货查验制度 | 建立健全制度 |
| 制度不落实 | 有制度不执行 | 严格执行制度 |
| 记录不完整 | 记录缺失或不全 | 完善记录 |

### 10.4 产品问题

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 产品不符合标准 | 检测不合格 | 调整生产工艺 |
| 超范围生产 | 生产许可外的产品 | 申请增加类别 |
| 标签不合格 | 标签不完整 | 修改标签 |

## 十一、食品生产许可审核检查清单

### 11.1 许可证检查
- [ ] 许可证是否有效
- [ ] 许可证编号是否正确
- [ ] 许可证内容是否完整
- [ ] 许可证是否与实际一致

### 11.2 生产条件检查
- [ ] 生产场所是否符合要求
- [ ] 设备设施是否齐全
- [ ] 人员是否合格
- [ ] 环境是否清洁

### 11.3 管理制度检查
- [ ] 制度是否健全
- [ ] 制度是否落实
- [ ] 记录是否完整
- [ ] 体系是否有效

### 11.4 产品检查
- [ ] 产品是否符合标准
- [ ] 是否在许可范围内
- [ ] 标签是否合规
- [ ] 检测是否合格

---

**注意：** 食品生产许可法规不断更新，具体审核时应查阅最新法规。如有复杂问题，建议咨询专业法律顾问或当地市场监管部门。
