# 食品标签标准详解

本文档详细解读GB 7718-2011和GB 28050-2011标准，用于食品标签合规审核。

## 一、GB 7718-2011《预包装食品标签通则》详解

### 1.1 适用范围

适用于直接提供给消费者的预包装食品标签，不适用于：
- 为食品生产经营者提供的预包装食品标签
- 散装食品
- 现制现售食品
- 食用农产品

### 1.2 基本原则

**3.1** 标签内容应真实、准确，不得有虚假内容
**3.2** 标签内容应通俗易懂、清晰醒目
**3.3** 标签内容应规范、完整
**3.4** 标签不得与包装物分离

### 1.3 强制标示内容

#### 3.1 食品名称

**要求：**
- 应在标签的醒目位置，清晰地标示反映食品真实属性的专用名称
- 当国家标准或行业标准中已规定了某食品的一个或几个名称时，应选用其中的一个或等效的名称
- 无国家标准或行业标准规定的名称时，应使用不使消费者误解或混淆的常用名称或通俗名称

**示例：**
- 正确：**"橙汁饮料"**（反映真实属性）
- 错误：**"天然健康饮品"**（不反映真实属性）

#### 3.2 配料表

**标示要求：**
- 以"配料"或"配料表"为引导词
- 各种配料按制造或加工食品时加入量的递减顺序排列
- 加入量小于2%的配料可不按递减顺序排列
- 复合配料应在配料表中标示原始配料

**特殊情况处理：**

| 情况 | 标示方式 | 示例 |
|-----|---------|------|
| 复合配料（加入量>25%） | 展开标示各原始配料 | "小麦粉（小麦粉、水、食用盐）" |
| 复合配料（加入量≤25%） | 标示复合配料名称 | "酱油"（可不展开） |
| 含有添加剂 | 标示添加剂通用名称 | "山梨酸钾" |
| 食品用香料 | 标示"食用香料"或"食用香精" | "食用香精" |
| 加工助剂 | 可不标示 | - |

**配料标示示例：**
```
配料：水、白砂糖、浓缩橙汁、果胶、柠檬酸、维生素C、β-胡萝卜素
```

#### 3.3 净含量和规格

**标示要求：**
- 净含量应与食品名称在包装物或容器的同一展示版面
- 应使用法定计量单位
- 净含量的字符高度应符合规定

**计量单位要求：**

| 计量类别 | 计量单位 | 示例 |
|---------|---------|------|
| 质量 | 克(g)、千克(kg) | 净含量：500g |
| 体积 | 毫升(mL)、升(L) | 净含量：250mL |
| 长度 | 毫米(mm)、厘米(cm)、米(m) | - |

**字符高度要求：**

| 净含量 | 字符最小高度 |
|--------|------------|
| ≤50mL或≤50g | ≥2mm |
| 50-200mL或50-200g | ≥3mm |
| 200-1000mL或200-1000g | ≥4mm |
| >1kg或>1L | ≥6mm |

#### 3.4 生产者、经销者信息

**必须标示：**
- 依法登记注册的名称、地址
- 联系方式（电话或网址）

**示例：**
```
生产商：XX食品有限公司
地址：XX省XX市XX区XX路XX号
电话：400-XXX-XXXX
```

#### 3.5 生产日期和保质期

**标示要求：**
- 应清晰标示生产日期和保质期
- 如日期标示采用"见包装某部位"的形式，应标示所在包装物的具体部位
- 日期标示不得另外加贴、补印或篡改

**格式要求：**
- 年：4位数字
- 月：2位数字
- 日：2位数字

**示例：**
- 生产日期：2024年02月27日 或 20240227
- 保质期至：2025年02月26日

#### 3.6 贮存条件

**应标示：**
- 明确的贮存条件
- 必要时标示开封后的贮存条件

**示例：**
- 常温保存
- 请冷藏保存（2-8℃）
- 避光、密封保存

#### 3.7 食品生产许可证编号

**格式：** SC + 14位阿拉伯数字

**结构：**
```
SC  [省份代码][市代码][区县代码][4位序号]
```

**示例：**
```
SC10633010612345
```
- SC：生产许可标识
- 106：食品类别编码（106代表饮料）
- 330106：行政区划（浙江省杭州市西湖区）
- 12345：企业序号

#### 3.8 产品标准代号

**应标示：**
- 产品执行的标准代号

**示例：**
- GB/T 10789-2015（饮料通则）
- GB 7101-2015（食品安全国家标准 饮料）
- QB/T 2300-2006（植物蛋白饮料）

### 1.4 可选标示内容

#### 3.9 批号
- 可根据需要标示产品批号

#### 3.10 食用方法
- 根据需要标示食用方法

#### 3.11 致敏物质
- 含有致敏物质的应标示

**常见致敏物质：**
- 含有麸质的谷物及其制品
- 甲壳纲类动物及其制品
- 鱼类及其制品
- 蛋类及其制品
- 花生及其制品
- 大豆及其制品
- 乳及乳制品
- 坚果及其制品

**标示示例：**
- "含有大豆、乳制品"
- "过敏原提示：本品含花生、坚果"

## 二、GB 28050-2011《预包装食品营养标签通则》详解

### 2.1 适用范围

适用于预包装食品营养标签的标示，不适用于：
- 保健食品
- 特殊膳食用食品
- 婴幼儿配方食品

### 2.2 强制标示内容

#### 2.2.1 营养成分表

**强制标示的4+1核心营养素：**
- 能量
- 蛋白质
- 脂肪
- 碳水化合物
- 钠

**营养成分表格式：**

```
营养成分表
项目        每100克(g)   NRV%
能量        1800千焦(kJ)  21%
蛋白质      8.0克(g)      13%
脂肪        10.0克(g)     17%
碳水化合物  65.0克(g)     22%
钠          200毫克(mg)   10%
```

**计算公式：**
```
NRV% = （某营养素含量 / 营养素参考值）× 100%
```

**营养素参考值（NRV）：**

| 营养素 | NRV |
|--------|-----|
| 能量 | 8400 kJ |
| 蛋白质 | 60 g |
| 脂肪 | 60 g |
| 碳水化合物 | 300 g |
| 钠 | 2000 mg |

#### 2.2.2 营养声称

**当进行营养声称时，必须标示：**
- 能量
- 蛋白质
- 脂肪
- 碳水化合物
- 钠
- 声称的营养素

### 2.3 营养声称标准

#### 2.3.1 能量和营养素含量声称

| 声称 | 含量要求（固体） | 含量要求（液体） |
|-----|----------------|----------------|
| 无/零/不含 | ≤X kJ/g | ≤X kJ/mL |
| 低 | ≤X kJ/100g | ≤X kJ/100mL |
| 减少/少 | 与参考食品相比减少≥25% | - |

**蛋白质含量声称：**
- "含有蛋白质"：≥10% NRV
- "高蛋白质"：≥20% NRV 或 ≥10g/100g

**脂肪含量声称：**
- "无或不含脂肪"：≤0.5g/100g
- "低脂肪"：≤3g/100g
- "脱脂"：≤0.5g/100mL（液态奶）

**钠含量声称：**
- "无或不含钠"：≤5mg/100g
- "极低钠"：≤40mg/100g
- "低钠"：≤120mg/100g

#### 2.3.2 比较声称

**要求：**
- 与被比较的食品具有可比性
- 比较的差异≥25%
- 明确说明比较对象

**示例：**
- "比普通XX少30%脂肪"
- "脂肪含量降低40%"

### 2.4 免除标示情形

**可以不标示营养标签的食品：**
1. 生鲜食品（如包装的生肉、生鱼、生蔬菜、水果）
2. 乙醇含量≥0.5%的饮料酒类
3. 包装总表面积≤100cm²的食品
4. 现制现售的食品
5. 包装的饮用水

### 2.5 标示数值允许误差

| 营养素 | 允许误差范围 |
|--------|------------|
| 能量、蛋白质、脂肪、碳水化合物 | ≤80%标示值 |
| 钠 | ≤120%标示值 |
| 维生素、矿物质 | ≥80%标示值 |

## 三、常见标签问题及整改建议

### 3.1 食品名称问题

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 名称不反映真实属性 | "黄金饮品" | 改为"橙汁饮料" |
| 使用夸大宣传用语 | "至尊XX" | 改为规范名称 |
| 中英文不符 | 名称不一致 | 统一使用规范名称 |

### 3.2 配料表问题

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 未按递减顺序排列 | 水、糖、果汁（糖含量>果汁） | 调整顺序 |
| 复合配料未展开 | "酱油"（加入量>25%） | 展开标示 |
| 添加剂未标通用名 | "防腐剂" | 改为"山梨酸钾" |

### 3.3 净含量问题

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 未使用法定单位 | "1斤" | 改为"500g" |
| 字符高度不足 | 净含量500g字符1.5mm | 增大至≥4mm |
| 未与食品名称同版面 | 分开标示 | 调整至同一版面 |

### 3.4 营养标签问题

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 强制项目缺失 | 缺少钠 | 补充钠含量 |
| NRV%计算错误 | 蛋白质NRV%错误 | 重新计算 |
| 营养声称无依据 | "高蛋白"但未达标 | 删除声称或达标 |

### 3.5 生产许可证编号问题

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 格式错误 | "QS12345678" | 改为"SC"开头 |
| 编号无效 | SC后数字不足14位 | 补全至14位 |
| 类别代码错误 | 饮料使用SC106 | 使用正确类别代码 |

## 四、标签审核检查清单

### 4.1 基础检查
- [ ] 标签是否清晰、完整
- [ ] 标签是否与包装分离
- [ ] 标签内容是否可清晰辨认

### 4.2 强制内容检查
- [ ] 食品名称是否规范、醒目
- [ ] 配料表是否完整、准确
- [ ] 净含量和规格是否正确标示
- [ ] 生产者信息是否完整
- [ ] 生产日期和保质期是否规范
- [ ] 贮存条件是否明确
- [ ] 生产许可证编号是否有效
- [ ] 产品标准代号是否正确

### 4.3 营养标签检查
- [ ] 是否有营养成分表
- [ ] 强制标示项目是否完整（4+1）
- [ ] NRV%计算是否正确
- [ ] 营养声称是否有依据

### 4.4 合规性检查
- [ ] 是否有虚假或夸大宣传
- [ ] 是否有绝对化用语
- [ ] 是否涉及疾病治疗功能
- [ ] 致敏物质是否标示

---

**注意：** 本文档为标准解读，具体审核时应查阅完整标准原文。如有疑问，建议咨询专业检测机构或法律顾问。
