# 核心法规条文摘要

本文档汇总了中国食品安全领域的核心法规条文，供审核时快速查阅。

## 一、食品安全相关法律

### 1.1 《中华人民共和国食品安全法》（2021年修订）

**核心条款：**

**第三条** 食品生产经营者对其生产经营食品的安全负责。

**第六十七条** 预包装食品的包装上应当有标签。标签应当标明下列事项：
1. 名称、规格、净含量、生产日期
2. 成分或者配料表
3. 生产者的名称、地址、联系方式
4. 保质期
5. 产品标准代号
6. 贮存条件
7. 所使用的食品添加剂在国家标准中的通用名称
8. 生产许可证编号
9. 法律、法规或者食品安全标准规定必须标明的其他事项

**第七十一条** 食品和食品添加剂的标签、说明书，不得含有虚假内容，不得涉及疾病预防、治疗功能。

**第七十四条** 保健食品声称保健功能，应当具有科学依据，不得对人体产生急性、亚急性或者慢性危害。

**第九十七条** 进口的预包装食品、食品添加剂应当有中文标签；依法应当有说明书的，还应当有中文说明书。

### 1.2 《中华人民共和国广告法》（2021年修订）

**核心条款：**

**第九条** 广告不得有下列情形：
1. 使用或者变相使用中华人民共和国的国旗、国歌、国徽
2. 使用或者变相使用国家机关、国家机关工作人员的名义或者形象
3. 使用"国家级""最高级""最佳"等用语
4. 妨碍社会公共秩序或者违背社会良好风尚

**第十七条** 除医疗、药品、医疗器械广告外，禁止其他任何广告涉及疾病治疗功能，并不得使用医疗用语或者易使推销的商品与药品、医疗器械相混淆的用语。

**第十八条** 保健食品广告不得含有下列内容：
1. 表示功效、安全性的断言或者保证
2. 涉及疾病预防、治疗功能
3. 声称或者暗示广告商品为保障健康所必需
4. 与药品、其他保健食品进行比较

**第二十八条** 广告以虚假或者引人误解的内容欺骗、误导消费者的，构成虚假广告。

## 二、食品安全国家标准

### 2.1 GB 7718-2011《食品安全国家标准 预包装食品标签通则》

**核心要求：**

**3.1** 直接向消费者提供的预包装食品标签标示应包括食品名称、配料表、净含量和规格、生产者和（或）经销者的名称、地址和联系方式、生产日期和保质期、贮存条件、食品生产许可证编号、产品标准代号及其他需要标示的内容。

**3.4** 配料表应以"配料"或"配料表"为引导词。各种配料应按制造或加工食品时加入量的递减顺序一一排列；加入量小于2%的配料可以不按递减顺序排列。

**3.5** 净含量应与食品名称在包装物或容器的同一展示版面标示。

### 2.2 GB 28050-2011《食品安全国家标准 预包装食品营养标签通则》

**核心要求：**

**2.1** 所有预包装食品营养标签标示内容应包括：能量、营养素参考值（NRV）和营养成分表。

**2.4** 营养成分表中强制标示的内容包括：能量、蛋白质、脂肪、碳水化合物、钠。

**3.1** 营养标签应标在向消费者提供的最小销售单元的包装上。

**4.1** 营养声称应符合营养声称标准条件和要求。

### 2.3 GB 2760-2014《食品安全国家标准 食品添加剂使用标准》

**核心要求：**

**2.1** 食品添加剂的使用应符合附录A中规定的使用范围及使用量。

**2.2** 食品用香料的使用应符合附录B的规定。

**2.3** 食品工业用加工助剂的使用应符合附录C的规定。

**3.1** 食品添加剂的使用不应掩盖食品本身或加工过程中的质量缺陷。

## 三、食品生产许可管理

### 3.1 《食品生产许可管理办法》（2020年修订）

**核心条款：**

**第二条** 在中华人民共和国境内，从事食品生产活动，应当依法取得食品生产许可。

**第十一条** 食品生产许可证编号由SC（"生产"的汉语拼音字母缩写）和14位阿拉伯数字组成。

**第二十九条** 食品生产许可证应当载明：生产者名称、社会信用代码、法定代表人（负责人）、住所、生产地址、食品类别、许可证编号、有效期等信息。

## 四、进出口食品管理

### 4.1 《中华人民共和国进出口食品安全管理办法》（2022年）

**核心条款：**

**第七条** 进口食品应当符合中国食品安全国家标准。

**第八条** 进口食品的境外生产企业应当获得海关总署注册。

**第十八条** 进口预包装食品应当有中文标签，标签应当符合中国法律法规和食品安全国家标准的要求。

**第三十条** 出口食品生产企业应当获得海关总署备案。

## 五、特殊食品管理

### 5.1 保健食品

- 需取得"蓝帽子"标志（保健食品批准证书）
- 仅可声称保健食品功能目录中的27种功能
- 标签必须注明"本品不能代替药物"

### 5.2 特殊医学用途配方食品

- 需取得国家市场监管总局注册
- 分为全营养配方食品、特定全营养配方食品、非全营养配方食品

### 5.3 婴幼儿配方食品

- 需取得产品配方注册
- 配方变更需重新注册
- 标签不得有"最""第一"等表述

## 六、常见违规情形

### 6.1 标签违规

| 违规类型 | 具体表现 | 法律后果 |
|---------|---------|---------|
| 标签缺失 | 缺少生产日期、保质期、配料表等 | 责令改正，罚款5000-5万元 |
| 虚假标注 | 虚构产地、生产日期、成分等 | 罚款货值金额10-20倍 |
| 标注不规范 | 字体过小、位置不当、格式错误 | 责令改正 |

### 6.2 广告违规

| 违规类型 | 具体表现 | 法律后果 |
|---------|---------|---------|
| 虚假广告 | 夸大功效、虚假承诺 | 罚款广告费用3-5倍 |
| 绝对化用语 | "最""第一""顶级"等 | 罚款20-100万元 |
| 医疗宣传 | 宣传治疗功能 | 罚款10-200万元 |

### 6.3 添加剂违规

| 违规类型 | 具体表现 | 法律后果 |
|---------|---------|---------|
| 超范围使用 | 在不允许的食品类别中使用 | 罚款货值金额10-20倍 |
| 超限量使用 | 超过最大使用量 | 罚款货值金额10-20倍 |
| 使用禁用物质 | 使用非食用物质 | 刑事责任 |

## 七、审核检查清单

### 7.1 基础信息检查
- [ ] 产品名称是否规范
- [ ] 产品类别是否准确
- [ ] 生产商信息是否完整

### 7.2 标签内容检查
- [ ] GB 7718要求的所有项目是否齐全
- [ ] 配料表是否按递减顺序排列
- [ ] 净含量标注是否正确
- [ ] 生产日期和保质期格式是否规范
- [ ] SC许可证编号是否有效

### 7.3 营养标签检查
- [ ] 是否有营养成分表
- [ ] 强制标示项目是否完整
- [ ] 数值计算是否正确
- [ ] 营养声称是否合规

### 7.4 添加剂检查
- [ ] 所有添加剂是否在GB 2760允许范围内
- [ ] 使用量是否超过最大限量
- [ ] 标注是否使用通用名称

### 7.5 广告宣传检查
- [ ] 是否使用绝对化用语
- [ ] 是否涉及疾病治疗功能
- [ ] 宣传内容是否有科学依据
- [ ] 是否有误导性表述

---

**注意：** 本文档为法规摘要，具体审核时应查阅完整法规条文。如遇复杂问题，建议咨询专业法律顾问。
